/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.arraylist;

import ch.nolix.core.commontypetool.iteratortool.IterableTool;
import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.arraylist.ArrayListCapacityCalculator;
import ch.nolix.core.container.arraylist.ArrayListIterator;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.commoncontainer.CountRequestable;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import ch.nolix.coreapi.container.list.IArrayList;

public final class ArrayList<E>
extends AbstractExtendedContainer<E>
implements IArrayList<E> {
    private int memberElementCount;
    private E[] memberElements = new Object[0];

    private ArrayList() {
    }

    public static <T> ArrayList<T> createEmpty() {
        return new ArrayList();
    }

    @SafeVarargs
    public static <T> ArrayList<T> withElements(T ... elements) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAtEnd(elements);
        return arrayList;
    }

    public static <T> ArrayList<T> withInitialCapacity(int initialCapacity) {
        Validator.assertThat(initialCapacity).thatIsNamed("initial capacity").isNotNegative();
        ArrayList arrayList = new ArrayList();
        arrayList.growToCapacityWhenCapacityIsBiggerThanCurrentCapacity(initialCapacity);
        return arrayList;
    }

    public static <T> ArrayList<T> withInitialCapacityFromSizeOfContainer(CountRequestable<?> container) {
        int initialCapacity = container.getCount();
        return ArrayList.withInitialCapacity(initialCapacity);
    }

    private static int getCountOfIterable(Iterable<?> iterable) {
        if (iterable instanceof IContainer) {
            IContainer container = (IContainer)iterable;
            return container.getCount();
        }
        return IterableTool.getCount(iterable);
    }

    @Override
    public void addAtEnd(E element) {
        Validator.assertThat(element).thatIsNamed("element").isNotNull();
        int localElementCount = this.getCount();
        int newElementCount = localElementCount + 1;
        this.growAtLeastToRequiredCapacity(newElementCount);
        this.memberElements[localElementCount] = element;
        this.memberElementCount = newElementCount;
    }

    @Override
    public <T extends E> void addAtEnd(T ... elements) {
        Validator.assertThatTheElements(elements).areNotNull();
        int elementCount = this.getCount();
        int newElementCount = elementCount + elements.length;
        this.growAtLeastToRequiredCapacity(newElementCount);
        System.arraycopy(elements, 0, this.memberElements, elementCount, elements.length);
        this.memberElementCount = newElementCount;
    }

    @Override
    public void addAtEnd(Iterable<? extends E> elements) {
        Validator.assertThatTheElements(elements).areNotNull();
        int newElementCount = this.getCount() + ArrayList.getCountOfIterable(elements);
        this.growAtLeastToRequiredCapacity(newElementCount);
        int index = this.getCount();
        for (E e : elements) {
            this.memberElements[index] = e;
            ++index;
        }
        this.memberElementCount = newElementCount;
    }

    @Override
    public void clear() {
        this.memberElements = new Object[0];
        this.memberElementCount = 0;
    }

    @Override
    public IArrayList<E> getCopy() {
        return ArrayList.withElements(this.memberElements);
    }

    @Override
    public int getCount() {
        return this.memberElementCount;
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        Validator.assertThat(oneBasedIndex).thatIsNamed("one-based index").isBetween(1, this.getCount());
        return this.memberElements[oneBasedIndex - 1];
    }

    @Override
    public void insertAtOneBasedIndex(int oneBasedIndex, E element) {
        Validator.assertThat(oneBasedIndex).thatIsNamed("one-based index").isBetween(1, this.getCount() + 1);
        if (oneBasedIndex <= this.getCount()) {
            Validator.assertThat(element).thatIsNamed("element").isNotNull();
            this.memberElements[oneBasedIndex - 1] = element;
        } else {
            this.addAtEnd(element);
        }
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return ArrayListIterator.forArrayAndMaxNextIndex(this.memberElements, this.getCount());
    }

    public String toString() {
        return this.toStringWithSeparator(',');
    }

    private int calculateTargetCapacityForRequiredCapacityWhenNeedsToGrowForIt(int requiredCapacity) {
        return ArrayListCapacityCalculator.calculateTargetCapacityForActualCapacityAndRequiredCapacity(this.getCapacity(), requiredCapacity);
    }

    private int getCapacity() {
        return this.memberElements.length;
    }

    private void growAtLeastToRequiredCapacity(int requiredCapacity) {
        if (this.needsToGrowForRequiredCapacity(requiredCapacity)) {
            this.growAtLeastToRequiredCapacityWhenNeedsToGrowForIt(requiredCapacity);
        }
    }

    private void growAtLeastToRequiredCapacityWhenNeedsToGrowForIt(int requiredCapacity) {
        int targetCapacity = this.calculateTargetCapacityForRequiredCapacityWhenNeedsToGrowForIt(requiredCapacity);
        this.growToCapacityWhenCapacityIsBiggerThanCurrentCapacity(targetCapacity);
    }

    private void growToCapacityWhenCapacityIsBiggerThanCurrentCapacity(int capacity) {
        Object[] newElements = new Object[capacity];
        System.arraycopy(this.memberElements, 0, newElements, 0, this.getCount());
        this.memberElements = newElements;
    }

    private boolean needsToGrowForRequiredCapacity(int requiredCapacity) {
        return ArrayListCapacityCalculator.arrayListNeedsToGrowForRequiredCapacity(this.getCapacity(), requiredCapacity);
    }
}

