/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.commontypetool.stringtool;

import ch.nolix.core.commontypetool.stringtool.CapitalSnakeCaseTransformer;
import ch.nolix.core.commontypetool.stringtool.PascalCaseTransformer;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnrepresentingArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.commontypetool.stringtool.IStringTool;
import ch.nolix.coreapi.commontypetool.stringtool.RegularExpressionPatternCatalog;

public final class StringToolUnit
implements IStringTool {
    @Override
    public String createStringWithoutLastCharacters(String string, int n) {
        Validator.assertThat(n).thatIsNamed("n").isBetween(0, string.length());
        return string.substring(0, string.length() - n);
    }

    @Override
    public String createTabs(int tabCount) {
        Validator.assertThat(tabCount).thatIsNamed("tab count").isNotNegative();
        StringBuilder stringBuilder = new StringBuilder();
        int i = 1;
        while (i <= tabCount) {
            stringBuilder.append('\t');
            ++i;
        }
        return stringBuilder.toString();
    }

    @Override
    public String getInBraces(Object object) {
        if (object == null) {
            throw ArgumentIsNullException.forArgumentType(Object.class);
        }
        return "{" + String.valueOf(object) + "}";
    }

    @Override
    public String getInParentheses(Object object, Object ... objects) {
        if (object == null) {
            throw ArgumentIsNullException.forArgumentName("1th object");
        }
        if (objects == null) {
            throw ArgumentIsNullException.forArgumentName("objects");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int index = 2;
        stringBuilder.append(object);
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o == null) {
                throw ArgumentIsNullException.forArgumentName(index + "th object");
            }
            stringBuilder.append(",");
            stringBuilder.append(o);
            ++index;
            ++n2;
        }
        return "(" + stringBuilder.toString() + ")";
    }

    @Override
    public String getInSingleQuotes(Object object) {
        if (object == null) {
            throw ArgumentIsNullException.forArgumentType(Object.class);
        }
        return "'" + String.valueOf(object) + "'";
    }

    @Override
    public boolean toBoolean(String string) {
        return switch (string) {
            case "0", "F", "FALSE", "False", "false" -> false;
            case "1", "T", "TRUE", "True", "true" -> true;
            default -> throw UnrepresentingArgumentException.forArgumentAndType(string, Boolean.TYPE);
        };
    }

    @Override
    public String toCapitalSnakeCase(String string) {
        return CapitalSnakeCaseTransformer.toCapitalSnakeCase(string);
    }

    @Override
    public double toDouble(String string) {
        if (!RegularExpressionPatternCatalog.DOUBLE_PATTERN.matcher(string).matches()) {
            throw UnrepresentingArgumentException.forArgumentAndType(string, Double.TYPE);
        }
        return Double.valueOf(string);
    }

    @Override
    public String toPascalCase(String string) {
        return PascalCaseTransformer.toPascalCase(string);
    }

    @Override
    public double toProportion(String string) {
        Validator.assertThat(string).thatIsNamed(String.class).isNotNull();
        if (string.endsWith("%")) {
            int percentageStringLength = string.length() - 1;
            String percentageString = string.substring(0, percentageStringLength);
            Double percentage = Double.valueOf(percentageString);
            return 0.01 * percentage;
        }
        return Double.valueOf(string);
    }
}

