/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.tech.math.bigdecimalmath;

import ch.nolix.core.datastructure.pair.Pair;
import ch.nolix.techapi.math.bigdecimalmath.ISequence;
import java.math.BigDecimal;
import java.util.ArrayList;

abstract class AbstractSequence<V>
implements ISequence<V> {
    private final ArrayList<Pair<V, BigDecimal>> valuesAndSquaredMagnitudes = new ArrayList();

    AbstractSequence() {
    }

    @Override
    public int getIterationCountWhereSquaredMagnitudeOfValueExceedsLimitOrMinusOne(BigDecimal limit, int maxIterationCount) {
        int i = 1;
        while (i <= maxIterationCount) {
            if (this.getSquaredMagnitudeOfValueAtOneBasedIndex(i).compareTo(limit) > 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public BigDecimal getSquaredMagnitudeOfValueAtOneBasedIndex(int oneBasedIndex) {
        this.calculateValuesAndSquaredMagnitudesToIndex(oneBasedIndex);
        return this.valuesAndSquaredMagnitudes.get(oneBasedIndex - 1).getStoredElement2();
    }

    @Override
    public V getValueAtOneBasedIndex(int oneBasedIndex) {
        this.calculateValuesAndSquaredMagnitudesToIndex(oneBasedIndex);
        return this.valuesAndSquaredMagnitudes.get(oneBasedIndex - 1).getStoredElement1();
    }

    protected abstract BigDecimal calculateSquaredMagnitudeForValue(V var1);

    protected abstract V calculateValue(int var1);

    protected V getValueAtIndexWhenCalculated(int index) {
        return this.valuesAndSquaredMagnitudes.get(index - 1).getStoredElement1();
    }

    private void calculateValuesAndSquaredMagnitudesToIndex(int index) {
        int i = this.valuesAndSquaredMagnitudes.size() + 1;
        while (i <= index) {
            V value = this.calculateValue(i);
            BigDecimal valueSquaredMagnitude = this.calculateSquaredMagnitudeForValue(value);
            this.valuesAndSquaredMagnitudes.add(new Pair<V, BigDecimal>(value, valueSquaredMagnitude));
            ++i;
        }
    }
}

