/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.main;

import ch.nolix.core.commontypetool.stringtool.StringTool;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.datamodel.id.IdCreator;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.web.cssmodel.ICssRule;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlElement;
import ch.nolix.system.element.property.MutableOptionalValue;
import ch.nolix.system.element.property.MutableValue;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.system.gui.background.Background;
import ch.nolix.system.style.stylable.AbstractStylableElement;
import ch.nolix.system.webgui.controltool.ControlAnalyser;
import ch.nolix.system.webgui.controltool.ControlTool;
import ch.nolix.system.webgui.main.ControlFactory;
import ch.nolix.system.webgui.main.LayerCssBuilder;
import ch.nolix.system.webgui.main.LayerHtmlBuilder;
import ch.nolix.system.webgui.mainvalidator.LayerValidator;
import ch.nolix.systemapi.element.base.IElement;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.graphic.image.IImage;
import ch.nolix.systemapi.gui.background.BackgroundType;
import ch.nolix.systemapi.gui.background.IBackground;
import ch.nolix.systemapi.gui.background.ImageApplication;
import ch.nolix.systemapi.gui.box.ContentAlignment;
import ch.nolix.systemapi.gui.colorgradient.IColorGradient;
import ch.nolix.systemapi.style.stylable.IStylableElement;
import ch.nolix.systemapi.webgui.controltool.IControlTool;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.ILayer;
import ch.nolix.systemapi.webgui.main.IWebGui;
import ch.nolix.systemapi.webgui.main.LayerRole;
import java.util.Optional;

public final class Layer
extends AbstractStylableElement<Layer>
implements ILayer<Layer> {
    public static final double DEFAULT_OPACITY = 1.0;
    public static final IColor DEFAULT_BACKGROUND_COLOR = X11ColorCatalog.WHITE;
    public static final ContentAlignment DEFAULT_CONTENT_POSITION = ContentAlignment.TOP;
    private static final String ROLE_HEADER = "Role";
    private static final String OPACITY_HEADER = "Opacity";
    private static final String BACKGROUND_HEADER = "Background";
    private static final String CONTENT_ALIGNMENT_HEADER = "ContentAlignment";
    private static final String ROOT_CONTROL_HEADER = "RootControl";
    private static final LayerValidator LAYER_VALIDATOR = new LayerValidator();
    private static final ControlAnalyser CONTROL_ANALYSER = new ControlAnalyser();
    private static final IControlTool CONTROL_TOOL = new ControlTool();
    private final String memberInternalId = "i" + IdCreator.createIdOf10HexadecimalCharacters();
    private final MutableOptionalValue<LayerRole> memberRole = new MutableOptionalValue<LayerRole>("Role", this::setRole, LayerRole::fromSpecification, Node::fromEnum);
    private final MutableValue<Double> opacity = new MutableValue<Double>("Opacity", 1.0, this::setOpacity, s -> StringTool.toProportion(s.getSingleChildNodeHeader()), Node::withChildNode);
    private final MutableOptionalValue<IBackground> background = new MutableOptionalValue<IBackground>("Background", this::setBackground, Background::fromSpecification, IElement::getSpecification);
    private final MutableValue<ContentAlignment> contentAlignment = new MutableValue<ContentAlignment>("ContentAlignment", DEFAULT_CONTENT_POSITION, this::setContentAlignment, ContentAlignment::fromSpecification, Node::fromEnum);
    private final MutableOptionalValue<IControl<?, ?>> rootControl = new MutableOptionalValue<IControl>("RootControl", iControl -> this.setRootControl((IControl)iControl), ControlFactory::createControlFromSpecification, IElement::getSpecification);
    private IWebGui<?> memberParentGui;

    public static Layer fromSpecification(INode<?> specification) {
        Layer layer = new Layer();
        layer.resetFromSpecification(specification);
        return layer;
    }

    @Override
    public boolean belongsToGui() {
        return this.memberParentGui != null;
    }

    @Override
    public boolean containsControl(IControl<?, ?> control) {
        return this.containsAny() && this.containsControlWhenContainsAny(control);
    }

    @Override
    public void clear() {
        if (this.containsAny()) {
            this.clearWhenIsNotEmpty();
        }
    }

    @Override
    public IBackground getBackground() {
        return (IBackground)this.background.getValue();
    }

    @Override
    public IColor getBackgroundColor() {
        return this.getBackground().getColor();
    }

    @Override
    public IColorGradient getBackgroundColorGradient() {
        return this.getBackground().getColorGradient();
    }

    @Override
    public IImage getBackgroundImage() {
        return this.getBackground().getImage();
    }

    @Override
    public ImageApplication getBackgroundImageApplication() {
        return this.getBackground().getImageApplication();
    }

    @Override
    public BackgroundType getBackgroundType() {
        return this.getBackground().getType();
    }

    @Override
    public ContentAlignment getContentAlignment() {
        return (ContentAlignment)((Object)this.contentAlignment.getValue());
    }

    @Override
    public ICssRule getCssRule() {
        return LayerCssBuilder.getCssRuleForLayer(this);
    }

    @Override
    public IHtmlElement getHtml() {
        return LayerHtmlBuilder.getHtmlElementForLayer(this);
    }

    @Override
    public String getInternalId() {
        return this.memberInternalId;
    }

    @Override
    public double getOpacity() {
        return (Double)this.opacity.getValue();
    }

    @Override
    public Optional<IControl<?, ?>> getOptionalStoredControlByInternalId(String internalId) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        IControl<?, ?> localRootControl = this.getStoredRootControl();
        if (localRootControl.hasInternalId(internalId)) {
            return Optional.of(localRootControl);
        }
        return localRootControl.getOptionalStoredChildControlByInternalId(internalId);
    }

    @Override
    public IContainer<IControl<?, ?>> getStoredControls() {
        if (this.isEmpty()) {
            return ImmutableList.createEmpty();
        }
        return CONTROL_TOOL.getListWithControlAndChildControlsRecursively(this.getStoredRootControl());
    }

    @Override
    public IWebGui<?> getStoredParentGui() {
        LAYER_VALIDATOR.assertBelongsToGui(this);
        return this.memberParentGui;
    }

    @Override
    public IControl<?, ?> getStoredRootControl() {
        return (IControl)this.rootControl.getValue();
    }

    @Override
    public LayerRole getRole() {
        return (LayerRole)((Object)this.memberRole.getValue());
    }

    @Override
    public IContainer<? extends IStylableElement<?>> getStoredChildStylableElements() {
        LinkedList childConfigurableElements = LinkedList.createEmpty();
        if (this.containsAny()) {
            childConfigurableElements.addAtEnd(this.getStoredRootControl());
        }
        return childConfigurableElements;
    }

    @Override
    public boolean hasBackground() {
        return this.background.containsAny();
    }

    @Override
    public boolean hasInternalId(String internalId) {
        return this.getInternalId().equals(internalId);
    }

    @Override
    public boolean hasRole() {
        return this.memberRole.containsAny();
    }

    @Override
    public boolean hasRole(String role) {
        return this.hasRole() && this.getRole().toString().equals(role);
    }

    @Override
    public void internalSetParentGui(IWebGui<?> parentGui) {
        Validator.assertThat(parentGui).thatIsNamed("parent GUI").isNotNull();
        LAYER_VALIDATOR.assertDoesNotBelongToGui(this);
        this.memberParentGui = parentGui;
    }

    @Override
    public boolean isEmpty() {
        return this.rootControl.isEmpty();
    }

    @Override
    public void removeBackground() {
        this.background.clear();
    }

    public void removeRole() {
        this.memberRole.clear();
    }

    @Override
    public void removeSelfFromGui() {
        if (this.belongsToGui()) {
            this.removeSelfFromGuiWhenBelongsToGui();
        }
    }

    public Layer setBackground(IBackground background) {
        this.background.setValue(background);
        return this;
    }

    @Override
    public Layer setBackgroundColor(IColor backgroundColor) {
        return this.setBackground(Background.withColor(backgroundColor));
    }

    @Override
    public Layer setBackgroundColorGradient(IColorGradient backgroundColorGradient) {
        return this.setBackground(Background.withColorGradient(backgroundColorGradient));
    }

    @Override
    public Layer setBackgroundImage(IImage backgroundImage) {
        return this.setBackground(Background.withImage(backgroundImage));
    }

    @Override
    public Layer setBackgroundImage(IImage backgroundImage, ImageApplication imageApplication) {
        return this.setBackground(Background.withImageAndImageApplication(backgroundImage, imageApplication));
    }

    @Override
    public Layer setRootControl(IControl<?, ?> rootControl) {
        rootControl.internalSetParentLayer(this);
        this.rootControl.setValue(rootControl);
        return this;
    }

    @Override
    public Layer setContentAlignment(ContentAlignment contentAlignment) {
        this.contentAlignment.setValue(contentAlignment);
        return this;
    }

    @Override
    public Layer setOpacity(double opacity) {
        Validator.assertThat(opacity).thatIsNamed("opacity").isBetween(0.0, 1.0);
        this.opacity.setValue(opacity);
        return this;
    }

    @Override
    public Layer setRole(LayerRole role) {
        this.memberRole.setValue(role);
        return this;
    }

    @Override
    protected void resetStylableElement() {
        this.removeRole();
        this.clear();
    }

    @Override
    protected void resetStyle() {
        this.setOpacity(1.0);
        this.removeBackground();
        this.setContentAlignment(DEFAULT_CONTENT_POSITION);
    }

    private void clearWhenIsNotEmpty() {
        this.rootControl.clear();
    }

    private boolean containsControlWhenContainsAny(IControl<?, ?> control) {
        IControl<?, ?> localRootControl = this.getStoredRootControl();
        if (localRootControl == control) {
            return true;
        }
        return CONTROL_ANALYSER.firstControlContainsSecondControl(localRootControl, control);
    }

    private void removeSelfFromGuiWhenBelongsToGui() {
        this.getStoredParentGui().removeLayer(this);
        this.memberParentGui = null;
    }
}

