/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.main;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.webapplication.base.AbstractWebClient;
import ch.nolix.system.webapplication.main.WebClientHtmlEventExecutor;
import ch.nolix.system.webapplication.main.WebClientSession;
import ch.nolix.system.webapplication.refreshqueue.WebClientRefreshQueue;
import ch.nolix.systemapi.webapplication.component.IComponent;
import ch.nolix.systemapi.webapplication.component.RefreshTrigger;
import ch.nolix.systemapi.webatomiccontrol.uploader.IUploader;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IWebGui;
import java.util.Base64;
import java.util.Optional;

public final class WebClient<C>
extends AbstractWebClient<WebClient<C>, C> {
    private static final WebClientHtmlEventExecutor WEB_CLIENT_HTML_EVENT_EXECUTOR = new WebClientHtmlEventExecutor();
    private final WebClientRefreshQueue refreshQueue = WebClientRefreshQueue.forCounterpartRunnerAndOpenStateRequestable(this::runOnCounterpart, this::isOpen);

    @Override
    protected INode<?> getDataFromHere(IChainedNode request) {
        throw InvalidArgumentException.forArgumentAndArgumentName(request, "reqest");
    }

    @Override
    protected void runHereOnBaseBackendWebClient(IChainedNode command) {
        switch (command.getHeader()) {
            case "GUI": {
                this.runGuiCommand(command.getNextNode());
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName(command, "command");
            }
        }
    }

    void internalUpdateControlOnCounterpart(IControl<?, ?> control, boolean updateConstellationOrStyle) {
        this.refreshQueue.updateControlOnCounterpart(control, updateConstellationOrStyle);
    }

    void internalUpdateControlsOnCounterpart(IContainer<IControl<?, ?>> controls, boolean updateConstellationOrStyle) {
        this.refreshQueue.updateControlsOnCounterpart(controls, updateConstellationOrStyle);
    }

    void internalUpdateCounterpartFromWebGui(IWebGui<?> webGui, boolean updateConstellationOrStyle) {
        this.refreshQueue.updateWebGuiOfCounterpart(webGui, updateConstellationOrStyle);
    }

    void internalRunOnCounterpart(IContainer<? extends IChainedNode> updateCommands) {
        this.runOnCounterpart(updateCommands);
    }

    private Optional<IComponent> getOptionalStoredParentComponentOfControl(IControl<?, ?> control) {
        Object e;
        if (control.isLinkedToAnObject() && (e = control.getStoredLinkedObjects().getStoredFirst()) instanceof IComponent) {
            IComponent component = (IComponent)e;
            return Optional.of(component);
        }
        if (control.belongsToControl()) {
            return this.getOptionalStoredParentComponentOfControl(control.getStoredParentControl());
        }
        return Optional.empty();
    }

    private void refreshCounterpartGui() {
        ((WebClientSession)this.getStoredCurrentSession()).refresh();
    }

    private void runCommandOnControl(IControl<?, ?> control, IChainedNode command) {
        switch (command.getHeader()) {
            case "RunHTMLEvent": {
                this.runHtmlEventCommand(control, command);
                break;
            }
            case "SetFile": {
                IUploader uploader = (IUploader)control;
                String fileString = command.getSingleChildNodeHeader();
                byte[] bytes = Base64.getDecoder().decode(fileString.substring(fileString.indexOf(44) + 1));
                uploader.internalSetFile(bytes);
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName(command, "command");
            }
        }
    }

    private void runControlCommand(IChainedNode guiCommand) {
        IChainedNode command = guiCommand.getNextNode();
        String internalControlId = guiCommand.getSingleChildNodeHeader();
        WebClientSession webClientSession = (WebClientSession)this.getStoredCurrentSession();
        IWebGui<?> gui = webClientSession.getStoredGui();
        IContainer<IControl<?, ?>> controls = gui.getStoredControls();
        Optional<IControl> control = controls.getOptionalStoredFirst(c -> c.hasInternalId(internalControlId));
        if (control.isPresent()) {
            this.runCommandOnControl(control.get(), command);
        }
    }

    private void runGuiCommand(IChainedNode guiCommand) {
        switch (guiCommand.getHeader()) {
            case "ControlByFixedId": {
                this.runControlCommand(guiCommand);
                break;
            }
            case "SetUserInputs": {
                this.runSetUserInputsCommand(guiCommand);
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName(guiCommand, "GUI command");
            }
        }
    }

    private void runHtmlEventCommand(IControl<?, ?> triggeredControl, IChainedNode htmlEventCommand) {
        String htmlEvent = htmlEventCommand.getSingleChildNodeHeader();
        WEB_CLIENT_HTML_EVENT_EXECUTOR.runHtmlEventOfTriggeredControlAndUpdateAccordingly(triggeredControl, htmlEvent, this::isOpen, this::refreshCounterpartGui, this::updateCounterpartWhenOpen);
    }

    private void runSetUserInputsCommand(IChainedNode guiCommand) {
        WebClientSession webClientSession = (WebClientSession)this.getStoredCurrentSession();
        IWebGui<?> gui = webClientSession.getStoredGui();
        IContainer<IControl<?, ?>> controls = gui.getStoredControls();
        for (IChainedNode iChainedNode : guiCommand.getChildNodes()) {
            String internalControlId = iChainedNode.getChildNodeAtOneBasedIndex(1).getHeader();
            String userInput = iChainedNode.getChildNodeAtOneBasedIndex(2).getHeaderOrEmptyString();
            Optional<IControl> control = controls.getOptionalStoredFirst(c -> c.hasInternalId(internalControlId));
            if (!control.isPresent()) continue;
            control.get().setUserInput(userInput);
        }
    }

    private void updateCounterpartWhenOpen(IComponent component) {
        RefreshTrigger refreshBehavior = component.getRefreshTrigger();
        switch (refreshBehavior) {
            case DO_NOT_REFRESH: {
                break;
            }
            case REFRESH_GUI: {
                this.refreshCounterpartGui();
                break;
            }
            case REFRESH_COMPONENT: {
                ((WebClientSession)this.getStoredCurrentSession()).updateControlOnCounterpart(component, true);
                break;
            }
            default: {
                throw InvalidArgumentException.forArgument((Object)refreshBehavior);
            }
        }
    }

    private void updateCounterpartWhenOpen(IControl<?, ?> control) {
        Optional<IComponent> component = this.getOptionalStoredParentComponentOfControl(control);
        if (component.isEmpty()) {
            this.refreshCounterpartGui();
        } else {
            this.updateCounterpartWhenOpen(component.get());
        }
    }
}

