/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.component;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotSupportMethodException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.webapplication.component.ComponentCssBuilder;
import ch.nolix.system.webapplication.component.ComponentHtmlBuilder;
import ch.nolix.system.webapplication.component.ComponentStyle;
import ch.nolix.system.webapplication.component.Controller;
import ch.nolix.system.webapplication.main.WebClientSession;
import ch.nolix.system.webgui.main.Control;
import ch.nolix.systemapi.webapplication.component.IComponent;
import ch.nolix.systemapi.webapplication.component.IComponentStyle;
import ch.nolix.systemapi.webapplication.component.RefreshTrigger;
import ch.nolix.systemapi.webgui.controltool.IControlCssBuilder;
import ch.nolix.systemapi.webgui.controltool.IControlHtmlBuilder;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IHtmlElementEvent;
import java.util.Optional;

public abstract class Component<C extends Controller<S>, S>
extends Control<IComponent, IComponentStyle>
implements IComponent {
    private static final ComponentHtmlBuilder HTML_BUILDER = new ComponentHtmlBuilder();
    private static final ComponentCssBuilder CSS_BUILDER = new ComponentCssBuilder();
    private final C memberController;
    private IControl<?, ?> childControl;

    protected Component(C controller, WebClientSession<S> webClientSession) {
        Validator.assertThat(controller).thatIsNamed(Controller.class).isNotNull();
        this.memberController = controller;
        ((Controller)this.memberController).setWebClientSession(webClientSession);
        this.rebuild();
    }

    @Override
    public Optional<String> getOptionalJavaScriptUserInputFunction() {
        return Optional.empty();
    }

    @Override
    public final IContainer<IControl<?, ?>> getStoredChildControls() {
        if (this.childControl == null) {
            return ImmutableList.createEmpty();
        }
        return ImmutableList.withElements(this.childControl);
    }

    @Override
    public final String getUserInput() {
        return "";
    }

    @Override
    public final boolean hasRole(String role) {
        return false;
    }

    @Override
    public final boolean isAlive() {
        return this.getStoredWebClientSession().isAlive();
    }

    @Override
    public final void rebuild() {
        this.childControl = this.createControl(this.getStoredController());
        this.childControl.internalSetParentControl(this);
        this.childControl.linkTo(this);
    }

    @Override
    public final void refresh() {
        RefreshTrigger refreshBehavior = this.getRefreshTrigger();
        switch (refreshBehavior) {
            case REFRESH_GUI: {
                this.rebuild();
                this.getStoredWebClientSession().refresh();
                break;
            }
            case REFRESH_COMPONENT: {
                this.rebuild();
                this.getStoredWebClientSession().updateControlOnCounterpart(this, true);
                break;
            }
            case DO_NOT_REFRESH: {
                break;
            }
            default: {
                throw InvalidArgumentException.forArgument((Object)refreshBehavior);
            }
        }
    }

    @Override
    public final void registerHtmlElementEventsAt(ILinkedList<IHtmlElementEvent> list) {
    }

    @Override
    public final void runHtmlEvent(String htmlEvent) {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "runHtmlEvent");
    }

    @Override
    public final IComponent setUserInput(String userInput) {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "setUserInput");
    }

    protected abstract IControl<?, ?> createControl(C var1);

    @Override
    protected final IComponentStyle createStyle() {
        return new ComponentStyle();
    }

    @Override
    protected final IControlCssBuilder<IComponent, IComponentStyle> getCssBuilder() {
        return CSS_BUILDER;
    }

    @Override
    protected final IControlHtmlBuilder<IComponent> getHtmlBuilder() {
        return HTML_BUILDER;
    }

    protected final S getStoredApplicationService() {
        return ((Controller)this.getStoredController()).getStoredApplicationService();
    }

    protected final C getStoredController() {
        return this.memberController;
    }

    protected final WebClientSession<S> getStoredWebClientSession() {
        return ((Controller)this.getStoredController()).getStoredWebClientSession();
    }

    @Override
    protected final void resetControl() {
        this.rebuild();
    }
}

