/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.base;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.net.target.IApplicationInstanceTarget;
import ch.nolix.system.webapplication.base.AbstractWebClient;
import ch.nolix.systemapi.gui.frontend.IFrontEndWriter;

final class FrontendWriter
implements IFrontEndWriter {
    private final AbstractWebClient<?, ?> parentBackendWebClient;

    private FrontendWriter(AbstractWebClient<?, ?> parentBackendWebClient) {
        Validator.assertThat(parentBackendWebClient).thatIsNamed("parent backend web client").isNotNull();
        this.parentBackendWebClient = parentBackendWebClient;
    }

    public static FrontendWriter forBackendWebClient(AbstractWebClient<?, ?> backendWebClient) {
        return new FrontendWriter(backendWebClient);
    }

    @Override
    public void openNewTabWithUrl(String url) {
        this.parentBackendWebClient.internalOpenNewTabOnCounterpartWithUrl(url);
    }

    @Override
    public void redirectTo(IApplicationInstanceTarget applicationInstanceTarget) {
        this.parentBackendWebClient.internalRedirectCounterpartTo(applicationInstanceTarget);
    }

    @Override
    public void redirectToUrl(String url) {
        this.parentBackendWebClient.internalRedirectCounterpartToUrl(url);
    }

    @Override
    public void saveFile(byte[] bytes) {
        this.parentBackendWebClient.internalSaveFileOnCounterpart(bytes);
    }

    @Override
    public void writeTextToClipboard(String text) {
        this.parentBackendWebClient.internalWriteTextToClipboardOfCounterpart(text);
    }
}

