/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlmidschema.databaseinitializer;

import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.system.sqlschema.adapter.SchemaReader;
import ch.nolix.systemapi.midschema.databaseinitializer.DatabaseState;
import ch.nolix.systemapi.sqlmidschema.databaseinitializer.IDatabaseStateAnalyser;
import ch.nolix.systemapi.sqlmidschema.databasestructure.FixTable;
import ch.nolix.systemapi.sqlschema.adapter.ISchemaReader;

public final class DatabaseStateAnalyser
implements IDatabaseStateAnalyser {
    private static DatabaseState getDatabaseSchemaState(ISchemaReader schemaReader) {
        if (schemaReader.tableExists(FixTable.DATABASE_PROPERTY.getName())) {
            return DatabaseState.INITIALIZED;
        }
        if (!schemaReader.tableExist()) {
            return DatabaseState.UNINITIALIZED;
        }
        return DatabaseState.INVALID;
    }

    @Override
    public DatabaseState getDatabasState(String databaseName, ISqlConnection sqlConnection) {
        SchemaReader schemaReader = SchemaReader.forDatabaseNameAndSqlConnection(databaseName, sqlConnection);
        return DatabaseStateAnalyser.getDatabaseSchemaState(schemaReader);
    }
}

