/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlmidschema.databaseinitializer;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.system.sqlmidschema.sqlschemadtocatalog.BackReferenceableColumnTableSqlSchemaDtoCatalog;
import ch.nolix.system.sqlmidschema.sqlschemadtocatalog.ColumnTableSqlSchemaDtoCatalog;
import ch.nolix.system.sqlmidschema.sqlschemadtocatalog.DatabasePropertyTableSqlSchemaDtoCatalog;
import ch.nolix.system.sqlmidschema.sqlschemadtocatalog.EntityIndexTableSqlSchemaDtoCatalog;
import ch.nolix.system.sqlmidschema.sqlschemadtocatalog.MultiBackReferenceEntryTableSqlSchemaDtoCatalog;
import ch.nolix.system.sqlmidschema.sqlschemadtocatalog.MultiReferenceEntryTableSqlSchemaDtoCatalog;
import ch.nolix.system.sqlmidschema.sqlschemadtocatalog.MultiValueEntryTableSqlSchemaDtoCatalog;
import ch.nolix.system.sqlmidschema.sqlschemadtocatalog.ReferenceableTableSqlSchemaDtoCatalog;
import ch.nolix.system.sqlmidschema.sqlschemadtocatalog.TableTableSqlSchemaDtoCatalog;
import ch.nolix.system.sqlmidschema.statementcreator.DatabaseInitializationStatementCreator;
import ch.nolix.systemapi.sqlmidschema.databaseinitializer.IDatabaseInitializerTool;
import ch.nolix.systemapi.sqlmidschema.statementcreator.IDatabaseInitializationStatementCreator;
import ch.nolix.systemapi.sqlschema.adapter.ISchemaWriter;
import ch.nolix.systemapi.time.moment.ITime;

public final class DatabaseInitializerTool
implements IDatabaseInitializerTool {
    private static final IDatabaseInitializationStatementCreator DATABASE_INITIALIZER_SQL_STATEMENT_CREATOR = new DatabaseInitializationStatementCreator();

    @Override
    public void initializeFixTables(ISchemaWriter schemaWriter) {
        schemaWriter.addTable(DatabasePropertyTableSqlSchemaDtoCatalog.DATABASE_PROPERTY_TABLE_SQL_DTO);
        schemaWriter.addTables(TableTableSqlSchemaDtoCatalog.TABLE_TABLE_SQL_DTO, ColumnTableSqlSchemaDtoCatalog.COLUMN_TABLE_SQL_DTO, ReferenceableTableSqlSchemaDtoCatalog.REFERENCEABLE_TABLE_TABLE_SQL_DTO, BackReferenceableColumnTableSqlSchemaDtoCatalog.BACK_REFERENCEABLE_COLUMN_TABLE_SQL_DTO);
        schemaWriter.addTable(EntityIndexTableSqlSchemaDtoCatalog.ENTITY_INDEX_SQL_SCHEMA_TABLE_DTO);
        schemaWriter.addTables(MultiValueEntryTableSqlSchemaDtoCatalog.MULTI_VALUE_ENTRY_TABLE_SQL_DTO, MultiReferenceEntryTableSqlSchemaDtoCatalog.MULTI_REFERENCE_ENTRY_TABLE_SQL_DTO, MultiBackReferenceEntryTableSqlSchemaDtoCatalog.MULTI_BACK_REFERENCE_ENTRY_TABLE_SQL_DTO);
        schemaWriter.saveChanges();
    }

    @Override
    public void saveSchemaTimestamp(ITime schemaTimestamp, ISqlConnection sqlConnection, String databaseName) {
        Validator.assertThat(databaseName).thatIsNamed("database name").isNotBlank();
        String query = DATABASE_INITIALIZER_SQL_STATEMENT_CREATOR.createStatementToCreateSchemaTimestampEntry(schemaTimestamp);
        sqlConnection.executeStatement("USE " + databaseName + ";", new String[0]);
        sqlConnection.executeStatement(query, new String[0]);
    }
}

