/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlmiddata.datawriter;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.sql.connection.AbstractSqlConnection;
import ch.nolix.core.sql.sqltool.SqlCollector;
import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.system.sqlmiddata.statementcreator.EntityStatementCreator;
import ch.nolix.system.sqlmiddata.statementcreator.MultiBackReferenceStatementCreator;
import ch.nolix.system.sqlmiddata.statementcreator.MultiReferenceStatementCreator;
import ch.nolix.system.sqlmiddata.statementcreator.MultiValueStatementCreator;
import ch.nolix.systemapi.middata.model.EntityCreationDto;
import ch.nolix.systemapi.middata.model.EntityDeletionDto;
import ch.nolix.systemapi.middata.model.EntityUpdateDto;
import ch.nolix.systemapi.sqlmiddata.statementcreator.IEntityStatementCreator;
import ch.nolix.systemapi.sqlmiddata.statementcreator.IMultiBackReferenceStatementCreator;
import ch.nolix.systemapi.sqlmiddata.statementcreator.IMultiReferenceStatementCreator;
import ch.nolix.systemapi.sqlmiddata.statementcreator.IMultiValueStatementCreator;
import ch.nolix.systemapi.time.moment.ITime;

public final class ExecutiveDataWriter {
    private static final IEntityStatementCreator ENTITY_STATEMENT_CREATOR = new EntityStatementCreator();
    private static final IMultiValueStatementCreator MULTI_VALUE_STATEMENT_CREATOR = new MultiValueStatementCreator();
    private static final IMultiReferenceStatementCreator MULTI_REFERENCE_STATEMENT_CREATOR = new MultiReferenceStatementCreator();
    private static final IMultiBackReferenceStatementCreator MULTI_BACK_REFERENCE_STATEMENT_CREATOR = new MultiBackReferenceStatementCreator();
    private int saveCount;
    private final SqlCollector sqlCollector = new SqlCollector();
    private final ISqlConnection sqlConnection;

    public ExecutiveDataWriter(String databaseName, ISqlConnection sqlConnection) {
        Validator.assertThat(sqlConnection).thatIsNamed(AbstractSqlConnection.class).isNotNull();
        this.sqlConnection = sqlConnection;
        sqlConnection.executeStatement("USE " + databaseName, new String[0]);
    }

    public void deleteEntity(String tableName, EntityDeletionDto entity) {
        String deleteEntityIndexStatement = ENTITY_STATEMENT_CREATOR.createStatementToDeleteEntityIndex(entity.id());
        String deleteEntityStatement = ENTITY_STATEMENT_CREATOR.createStatementToDeleteEntity(tableName, entity);
        this.sqlCollector.addSqlStatement(deleteEntityIndexStatement, deleteEntityStatement);
    }

    public void deleteEntriesFromMultiReference(String entityId, String multiReferenceColumnId) {
        String statement = MULTI_REFERENCE_STATEMENT_CREATOR.createStatementToDeleteMultiReferenceEntries(entityId, multiReferenceColumnId);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void deleteEntriesFromMultiValue(String entityId, String multiValueColumnId) {
        String statement = MULTI_VALUE_STATEMENT_CREATOR.createStatementToDeleteMultiValueEntries(entityId, multiValueColumnId);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void deleteEntryFromMultiReference(String entityId, String multiReferenceColumnId, String referencedEntityId) {
        String statement = MULTI_REFERENCE_STATEMENT_CREATOR.createStatementToDeleteMultiReferenceEntry(entityId, multiReferenceColumnId, referencedEntityId);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void deleteMultiValueEntry(String entityId, String multiValueColumnId, String value) {
        String statement = MULTI_VALUE_STATEMENT_CREATOR.createStatementToDeleteMultiValueEntry(entityId, multiValueColumnId, value);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void deleteMultiBackReferenceEntry(String entityId, String multiBackReferenceColumnId, String backReferencedEntityId) {
        String statement = MULTI_BACK_REFERENCE_STATEMENT_CREATOR.createStatementToDeleteMultiBackReferenceEntry(entityId, multiBackReferenceColumnId, backReferencedEntityId);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void expectGivenSchemaTimestamp(ITime schemaTimestamp) {
        this.sqlCollector.addSqlStatement(ENTITY_STATEMENT_CREATOR.createStatementToExpectGivenSchemaTimestamp(schemaTimestamp), new String[0]);
    }

    public void expectTableContainsEntity(String tableName, String entityId) {
        String statement = ENTITY_STATEMENT_CREATOR.createStatementToExpectTableContainsEntity(tableName, entityId);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public int getSaveCount() {
        return this.saveCount;
    }

    public boolean hasChanges() {
        return this.sqlCollector.containsAny();
    }

    public void insertEntity(String tableName, EntityCreationDto newEntity) {
        String insertEntityIndexStatement = ENTITY_STATEMENT_CREATOR.createStatementToInsertEntityIndex(tableName, newEntity.id());
        String insertEntityStatement = ENTITY_STATEMENT_CREATOR.createStatementToInsertEntity(tableName, newEntity);
        this.sqlCollector.addSqlStatement(insertEntityIndexStatement, insertEntityStatement);
    }

    public void insertEntryIntoMultiBackReference(String entityId, String multiBackReferenceColumnId, String backReferencedEntityId, String backReferencedEntityTableId) {
        String statement = MULTI_BACK_REFERENCE_STATEMENT_CREATOR.createStatementToInsertMultiBackReferenceEntry(entityId, multiBackReferenceColumnId, backReferencedEntityId, backReferencedEntityTableId);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void insertMultiReferenceEntry(String entityId, String multiReferenceColumnId, String referencedEntityId, String referencedEntityTableId) {
        String statement = MULTI_REFERENCE_STATEMENT_CREATOR.createStatementToInsertMultiReferenceEntry(entityId, multiReferenceColumnId, referencedEntityId, referencedEntityTableId);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void insertEntryIntoMultiValue(String entityId, String multiValueColumnId, String entry) {
        String statement = MULTI_VALUE_STATEMENT_CREATOR.createStatementToInsertMultiValueEntry(entityId, multiValueColumnId, entry);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }

    public void reset() {
        this.sqlCollector.clear();
    }

    public void saveChangesAndReset() {
        this.sqlCollector.executeAndClearUsingConnection(this.sqlConnection);
        ++this.saveCount;
    }

    public void updateEntityOnTable(String tableName, EntityUpdateDto entityUpdate) {
        String statement = ENTITY_STATEMENT_CREATOR.createStatementToUpdateEntityOnTable(tableName, entityUpdate);
        this.sqlCollector.addSqlStatement(statement, new String[0]);
    }
}

