/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.sqlmiddata.datareader;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.system.midschemaview.modelsearcher.DatabaseViewSearcher;
import ch.nolix.system.sqlmiddata.datareader.InternalDataReader;
import ch.nolix.system.time.moment.Time;
import ch.nolix.systemapi.middata.adapter.IDataReader;
import ch.nolix.systemapi.middata.model.EntityLoadingDto;
import ch.nolix.systemapi.middata.model.MultiBackReferenceEntryDto;
import ch.nolix.systemapi.middata.model.MultiReferenceEntryDto;
import ch.nolix.systemapi.midschema.structure.ColumnIdentification;
import ch.nolix.systemapi.midschema.structure.TableIdentification;
import ch.nolix.systemapi.midschemaview.model.ColumnViewDto;
import ch.nolix.systemapi.midschemaview.model.DatabaseViewDto;
import ch.nolix.systemapi.midschemaview.model.TableViewDto;
import ch.nolix.systemapi.midschemaview.modelsearcher.IDatabaseViewSearcher;

public final class DataReader
implements IDataReader {
    private static final IDatabaseViewSearcher DATABASE_VIEW_SEARCHER = new DatabaseViewSearcher();
    private final ICloseController closeController = CloseController.forElement(this);
    private final DatabaseViewDto databaseView;
    private final InternalDataReader internalDataReader;

    private DataReader(String databaseName, DatabaseViewDto databaseView, ISqlConnection sqlConnection) {
        Validator.assertThat(databaseView).thatIsNamed("database view").isNotNull();
        this.databaseView = databaseView;
        this.internalDataReader = new InternalDataReader(databaseName, sqlConnection);
        this.createCloseDependencyTo(sqlConnection);
    }

    public static DataReader forDatabaseNameAndDatabaseSchemaViewAndSqlConnection(String databaseName, DatabaseViewDto databaseView, ISqlConnection sqlConnection) {
        return new DataReader(databaseName, databaseView, sqlConnection);
    }

    @Override
    public String getDatabaseName() {
        return this.internalDataReader.getDatabaseName();
    }

    @Override
    public int getEntityCount(String tableName) {
        return this.internalDataReader.getEntityCount(tableName);
    }

    @Override
    public Time getSchemaTimestamp() {
        return this.internalDataReader.getSchemaTimestamp();
    }

    @Override
    public ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public IContainer<String> loadMultiBackReferenceBackReferencedEntityIds(String tableName, String entityId, String multiBackReferenceColumnName) {
        ColumnViewDto multiBackReferenceColumnView = this.getColumnViewByTableNameAndColumnName(tableName, multiBackReferenceColumnName);
        String multiBackReferenceColumnId = multiBackReferenceColumnView.id();
        return this.internalDataReader.loadMultiBackReferenceEntriesIds(entityId, multiBackReferenceColumnId);
    }

    @Override
    public IContainer<MultiBackReferenceEntryDto> loadMultiBackReferenceEntries(TableIdentification table, String entityId, ColumnIdentification multiBackReferenceColumn) {
        String multiBackReferenceColumnId = multiBackReferenceColumn.columnId();
        return this.internalDataReader.loadMultiBackReferenceEntries(table, entityId, multiBackReferenceColumnId);
    }

    @Override
    public IContainer<MultiReferenceEntryDto> loadMultiReferenceEntries(String tableName, String entityId, String multiReferenceColumnName) {
        ColumnViewDto multiReferenceColumnView = this.getColumnViewByTableNameAndColumnName(tableName, multiReferenceColumnName);
        String multiReferenceColumnId = multiReferenceColumnView.name();
        return this.internalDataReader.loadMultiReferenceEntries(entityId, multiReferenceColumnId, this.databaseView);
    }

    @Override
    public IContainer<Object> loadMultiValueValues(String tableName, String entityId, String multiValueColumnName) {
        ColumnViewDto multiValueColumnView = this.getColumnViewByTableNameAndColumnName(tableName, multiValueColumnName);
        return this.internalDataReader.loadMultiValueEntries(entityId, multiValueColumnView);
    }

    @Override
    public IContainer<EntityLoadingDto> loadEntities(String tableName) {
        TableViewDto tableView = this.getTableViewByTableName(tableName);
        return this.internalDataReader.loadEntitiesOfTable(tableView);
    }

    @Override
    public EntityLoadingDto loadEntity(String tableName, String entityId) {
        TableViewDto tableView = this.getTableViewByTableName(tableName);
        return this.internalDataReader.loadEntity(tableView, entityId);
    }

    @Override
    public void noteClose() {
    }

    @Override
    public boolean tableContainsEntityWithValueAtColumn(String tableName, String columnName, String value) {
        ColumnViewDto columnview = this.getColumnViewByTableNameAndColumnName(tableName, columnName);
        return this.internalDataReader.tableContainsEntityWithGivenValueAtGivenColumn(tableName, columnview, value);
    }

    @Override
    public boolean tableContainsEntityWithValueAtColumnIgnoringEntities(String tableName, String columnName, String value, IContainer<String> entitiesToIgnoreIds) {
        ColumnViewDto columnview = this.getColumnViewByTableNameAndColumnName(tableName, columnName);
        return this.internalDataReader.tableContainsEntityWithGivenValueAtGivenColumnIgnoringGivenEntities(tableName, columnview, value, entitiesToIgnoreIds);
    }

    @Override
    public boolean tableContainsEntity(String tableName, String entityId) {
        return this.internalDataReader.tableContainsEntityWithGivenId(tableName, entityId);
    }

    private ColumnViewDto getColumnViewByTableNameAndColumnName(String tableName, String columnName) {
        return DATABASE_VIEW_SEARCHER.getColumnViewByTableNameAndColumnName(this.databaseView, tableName, columnName);
    }

    private TableViewDto getTableViewByTableName(String tableName) {
        return DATABASE_VIEW_SEARCHER.getTableViewByTableName(this.databaseView, tableName);
    }
}

