/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.model;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.system.objectschema.model.Column;
import ch.nolix.system.objectschema.model.Table;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.objectschema.model.IColumn;
import ch.nolix.systemapi.objectschema.model.ITable;

public final class ColumnMapper {
    private ColumnMapper() {
    }

    public static IContainer<Column> mapMidSchemaTableDtoToLoadedColumns(TableDto midTableDto, IContainer<Table> tables) {
        String tableName = midTableDto.name();
        Table table = tables.getStoredFirst(t -> t.hasName(tableName));
        IContainer<ColumnDto> midColumns = midTableDto.columns();
        return midColumns.to(c -> ColumnMapper.mapMidSchemaColumnDtoToLoadedColumn(table, c, tables));
    }

    private static Column mapMidSchemaColumnDtoToLoadedColumn(Table parentTable, ColumnDto midColumnDto, IContainer<Table> tables) {
        String id = midColumnDto.id();
        String name = midColumnDto.name();
        FieldType fieldType = midColumnDto.fieldType();
        DataType dataType = midColumnDto.dataType();
        IContainer<String> referenceableTableIds = midColumnDto.referenceableTableIds();
        IContainer<String> backReferenceableColumnsIds = midColumnDto.backReferenceableColumnIds();
        IContainer<Table> referenceableTables = tables.getStoredSelected(t -> referenceableTableIds.containsAny(t::hasId));
        IContainer columns = tables.toMultiples(ITable::getStoredColumns);
        IContainer<IColumn> backReferenceableColumns = columns.getStoredSelected(c -> backReferenceableColumnsIds.containsAny(c::hasId));
        Column column = Column.withIdAndNameAndContentModel(id, name, fieldType, dataType, referenceableTables, backReferenceableColumns);
        column.setLoaded();
        column.setParentTableAttribute(parentTable);
        return column;
    }
}

