/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.persistence;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.system.objectdata.middatamodelmapper.MultiValueEntryDtoMapper;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.middata.model.MultiValueEntryDto;
import ch.nolix.systemapi.objectdata.middatamodelmapper.IMultiValueEntryDtoMapper;
import ch.nolix.systemapi.objectdata.model.IMultiValueFieldEntry;
import ch.nolix.systemapi.objectdata.perstistence.IMultiValueFieldEntrySaver;

public final class MultiValueFieldEntrySaver
implements IMultiValueFieldEntrySaver {
    private static final IMultiValueEntryDtoMapper MULTI_VALUE_ENTRY_DTO_MAPPER = new MultiValueEntryDtoMapper();

    @Override
    public void saveMultiValueFieldEntryChange(IMultiValueFieldEntry<?> multiValueFieldEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        DatabaseObjectState multiValueEntryState = (DatabaseObjectState)((Object)multiValueFieldEntry.getState());
        switch (multiValueEntryState) {
            case NEW: {
                this.saveMultiValueFieldEntryCreation(multiValueFieldEntry, dataAndSchemaAdapter);
                break;
            }
            case DELETED: {
                this.saveMultiValueFieldEntryDeletion(multiValueFieldEntry, dataAndSchemaAdapter);
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName((Object)multiValueEntryState, "state of multi value field entry");
            }
        }
    }

    @Override
    public void saveMultiValueFieldEntryCreation(IMultiValueFieldEntry<?> multiValueFieldEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        MultiValueEntryDto multiValueEntryDto = MULTI_VALUE_ENTRY_DTO_MAPPER.mapMultiValueEntryToMultiValueEntryDto(multiValueFieldEntry);
        dataAndSchemaAdapter.insertMultiValueEntry(multiValueEntryDto);
    }

    @Override
    public void saveMultiValueFieldEntryDeletion(IMultiValueFieldEntry<?> multiValueFieldEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        MultiValueEntryDto multiValueEntryDto = MULTI_VALUE_ENTRY_DTO_MAPPER.mapMultiValueEntryToMultiValueEntryDto(multiValueFieldEntry);
        dataAndSchemaAdapter.deleteMultiValueEntry(multiValueEntryDto);
    }
}

