/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.datamodel.fieldvalue.ValueMapper;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.coreapi.datamodel.fieldvalue.IValueMapper;
import ch.nolix.system.objectdata.fieldvalidator.ValueFieldValidator;
import ch.nolix.system.objectdata.model.AbstractBaseValueField;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectdata.fieldvalidator.IValueFieldValidator;
import ch.nolix.systemapi.objectdata.model.IValueField;

public final class ValueField<V>
extends AbstractBaseValueField<V>
implements IValueField<V> {
    private static final IValueFieldValidator VALUE_VALIDATOR = new ValueFieldValidator();
    private static final IValueMapper VALUE_MAPPER = new ValueMapper();
    private V internalValue;

    private ValueField(Class<V> valueType) {
        super(valueType);
    }

    public static <V2> ValueField<V2> withInitialValue(V2 initialValue) {
        ValueField<?> value = ValueField.withValueType(initialValue.getClass());
        value.setValue(initialValue);
        return value;
    }

    public static <V2> ValueField<V2> withValueType(Class<V2> valueType) {
        return new ValueField<V2>(valueType);
    }

    @Override
    public V getStoredValue() {
        VALUE_VALIDATOR.assertIsNotEmpty(this);
        return this.internalValue;
    }

    @Override
    public FieldType getType() {
        return FieldType.VALUE_FIELD;
    }

    @Override
    public void internalSetNullableValue(Object nullableValue, String nullableAdditionalValue) {
        this.internalValue = nullableValue;
    }

    @Override
    public boolean isEmpty() {
        return this.internalValue == null;
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public void setValue(V value) {
        VALUE_VALIDATOR.assertCanSetValue(this, value);
        this.updateStateForSetValue(value);
        this.setAsEditedAndRunPossibleUpdateAction();
    }

    @Override
    public void setValueFromString(String string) {
        DataType dataType = DataType.forType(this.getValueType());
        Object value = VALUE_MAPPER.mapStringToValue(string, dataType);
        this.setValue(value);
    }

    private void updateStateForSetValue(V value) {
        this.internalValue = value;
    }
}

