/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.expectation;

import ch.nolix.core.misc.function.FunctionService;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.expectation.MultiReferenceEntryExpectationAdder;
import ch.nolix.system.objectdata.fieldexaminer.FieldExaminer;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.objectdata.expectation.IFieldExpectationAdder;
import ch.nolix.systemapi.objectdata.expectation.IMultiReferenceEntryExpectationAdder;
import ch.nolix.systemapi.objectdata.fieldexaminer.IFieldExaminer;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IMultiReference;
import ch.nolix.systemapi.objectdata.model.IMultiReferenceEntry;
import ch.nolix.systemapi.objectdata.model.IOptionalReference;
import ch.nolix.systemapi.objectdata.model.IReference;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class FieldExpectationAdder
implements IFieldExpectationAdder {
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();
    private static final IMultiReferenceEntryExpectationAdder MULTI_REFERENCE_ENTRY_EXPECTATION_ADDER = new MultiReferenceEntryExpectationAdder();

    @Override
    public void addExpectationThatNewlyReferencedEntitiesExist(IField field, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        IField iField = field;
        Objects.requireNonNull(iField);
        IField iField2 = iField;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IReference.class, IOptionalReference.class, IMultiReference.class}, (Object)iField2, 0)) {
            case 0: {
                IReference reference = (IReference)iField2;
                this.addExpectationThatNewlyReferencedEntitiesExist(reference, dataAndSchemaAdapter);
                break;
            }
            case 1: {
                IOptionalReference optionalReference = (IOptionalReference)iField2;
                this.addExpectationThatNewlyReferencedEntitiesExist(optionalReference, dataAndSchemaAdapter);
                break;
            }
            case 2: {
                IMultiReference multiReference = (IMultiReference)iField2;
                this.addExpectationThatNewlyReferencedEntitiesExist(multiReference, dataAndSchemaAdapter);
                break;
            }
            default: {
                FunctionService.doNothing();
            }
        }
    }

    @Override
    public void addExpectationThatNewlyReferencedEntitiesExist(IMultiReference<? extends IEntity> multiReference, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        IContainer<IMultiReferenceEntry<? extends IEntity>> newAndDeletedEntries = multiReference.getStoredNewAndDeletedEntries();
        for (IMultiReferenceEntry iMultiReferenceEntry : newAndDeletedEntries) {
            MULTI_REFERENCE_ENTRY_EXPECTATION_ADDER.addExpectationThatNewlyReferencedEntitiesExistIfMultiReferenceEntryIsNew(iMultiReferenceEntry, dataAndSchemaAdapter);
        }
    }

    @Override
    public void addExpectationThatNewlyReferencedEntitiesExist(IOptionalReference<? extends IEntity> optionalReference, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        if (optionalReference.containsAny()) {
            String referencedTableName = optionalReference.getReferencedTableName();
            String referencedEntityId = optionalReference.getReferencedEntityId();
            dataAndSchemaAdapter.expectTableContainsEntity(referencedTableName, referencedEntityId);
        }
    }

    @Override
    public void addExpectationThatNewlyReferencedEntitiesExist(IReference<? extends IEntity> reference, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        String referencedTableName = reference.getReferencedTableName();
        String referencedEntityId = reference.getReferencedEntityId();
        dataAndSchemaAdapter.expectTableContainsEntity(referencedTableName, referencedEntityId);
    }

    @Override
    public void addExpectationThatNewlyReferencedEntitiesExistIfFieldIsNewOrEdited(IField field, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        if (FIELD_EXAMINER.isNewOrEdited(field)) {
            this.addExpectationThatNewlyReferencedEntitiesExist(field, dataAndSchemaAdapter);
        }
    }
}

