/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemidschema.schemawriter;

import ch.nolix.core.document.node.MutableNode;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.system.nodemidschema.schemawriter.SchemaWriterActionProvider;
import ch.nolix.system.time.moment.IncrementalCurrentTimeCreator;
import ch.nolix.systemapi.midschema.adapter.ISchemaWriter;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.midschema.structure.ColumnIdentification;
import ch.nolix.systemapi.midschema.structure.TableIdentification;
import ch.nolix.systemapi.time.moment.IIncrementalCurrentTimeCreator;
import ch.nolix.systemapi.time.moment.ITime;

public final class SchemaWriter
implements ISchemaWriter {
    private static final IIncrementalCurrentTimeCreator INCREMENTAL_CURRENT_TIME_CREATOR = new IncrementalCurrentTimeCreator();
    private final ICloseController closeController = CloseController.forElement(this);
    private int saveCount;
    private final IMutableNode<?> nodeDatabase;
    private IMutableNode<?> editedNodeDatabase;
    private boolean hasChanges;

    private SchemaWriter(IMutableNode<?> nodeDatabase) {
        Validator.assertThat(nodeDatabase).thatIsNamed("database Node").isNotNull();
        this.nodeDatabase = nodeDatabase;
        this.reset();
    }

    public static SchemaWriter forNodeDatabase(IMutableNode<?> nodeDatabase) {
        return new SchemaWriter(nodeDatabase);
    }

    @Override
    public void addColumn(TableIdentification table, ColumnDto column) {
        SchemaWriterActionProvider.addColumn(this.editedNodeDatabase, table, column);
        this.hasChanges = true;
    }

    @Override
    public void addTable(TableDto table) {
        SchemaWriterActionProvider.addTable(this.editedNodeDatabase, table);
        this.hasChanges = true;
    }

    @Override
    public void deleteColumn(TableIdentification table, String columnName) {
        SchemaWriterActionProvider.deleteColumn(this.editedNodeDatabase, table, columnName);
        this.hasChanges = true;
    }

    @Override
    public void deleteTable(String tableName) {
        SchemaWriterActionProvider.deleteTable(this.editedNodeDatabase, tableName);
        this.hasChanges = true;
    }

    @Override
    public ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public int getSaveCount() {
        return this.saveCount;
    }

    @Override
    public boolean hasChanges() {
        return this.hasChanges;
    }

    @Override
    public void noteClose() {
    }

    @Override
    public void renameColumn(String tableName, String columnName, String newColumnName) {
        SchemaWriterActionProvider.renameColumn(this.editedNodeDatabase, tableName, columnName, newColumnName);
        this.hasChanges = true;
    }

    @Override
    public void renameTable(String tableName, String newTableName) {
        SchemaWriterActionProvider.renameTable(this.editedNodeDatabase, tableName, newTableName);
        this.hasChanges = true;
    }

    @Override
    public void reset() {
        this.editedNodeDatabase = MutableNode.fromNode(this.nodeDatabase);
        this.hasChanges = false;
    }

    @Override
    public void saveChanges() {
        try {
            this.setSchemaTimestamp(INCREMENTAL_CURRENT_TIME_CREATOR.getCurrentTime());
            this.nodeDatabase.setChildNodes(this.editedNodeDatabase.getStoredChildNodes());
            ++this.saveCount;
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void setColumnModel(TableIdentification table, ColumnIdentification column, FieldType fieldType, DataType dataType, IContainer<String> referenceableTableIds, IContainer<String> backReferenceableColumnIds) {
        SchemaWriterActionProvider.setColumnModel(this.editedNodeDatabase, table, column, fieldType, dataType, referenceableTableIds, backReferenceableColumnIds);
        this.hasChanges = true;
    }

    private void setSchemaTimestamp(ITime schemaTimestamp) {
        SchemaWriterActionProvider.setSchemaTimestamp(this.editedNodeDatabase, schemaTimestamp);
        this.hasChanges = true;
    }
}

