/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemiddata.nodemapper;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.document.node.Node;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.midschemaview.modelsearcher.TableViewSearcher;
import ch.nolix.system.nodemiddata.nodemapper.ContentFieldNodeMapper;
import ch.nolix.systemapi.middata.model.EntityCreationDto;
import ch.nolix.systemapi.middata.model.ValueStringFieldDto;
import ch.nolix.systemapi.midschema.databasestructure.FixDatabasePropertyCatalogue;
import ch.nolix.systemapi.midschemaview.model.ColumnViewDto;
import ch.nolix.systemapi.midschemaview.model.TableViewDto;
import ch.nolix.systemapi.midschemaview.modelsearcher.ITableViewSearcher;
import ch.nolix.systemapi.nodemiddata.nodemapper.IContentFieldNodeMapper;
import ch.nolix.systemapi.nodemiddata.nodemapper.IFieldNodeMapper;

public final class FieldNodeMapper
implements IFieldNodeMapper {
    private static final ITableViewSearcher TABLE_VIEW_SEARCHER = new TableViewSearcher();
    private static final IContentFieldNodeMapper CONTENT_FIELD_NODE_MAPPER = new ContentFieldNodeMapper();

    @Override
    public IContainer<INode<?>> mapEntityCreationDtoToFieldNodes(EntityCreationDto entityCreationDto, long saveStamp, TableViewDto tableView) {
        int size = FixDatabasePropertyCatalogue.NUMBER_OF_ENTITY_META_FIELDS + tableView.columnViews().getCount();
        INode[] attributes = new INode[size];
        String entityId = entityCreationDto.id();
        attributes[0] = Node.withHeader(entityId);
        attributes[1] = Node.withHeader(saveStamp);
        attributes[2] = Node.EMPTY_NODE;
        attributes[3] = Node.EMPTY_NODE;
        for (ValueStringFieldDto f : entityCreationDto.contentFields()) {
            ColumnViewDto columnView = TABLE_VIEW_SEARCHER.getColumnViewByColumnName(tableView, f.columnName());
            int columnZeroBasedOrdinalIndex = columnView.oneBasedOrdinalIndex() - 1;
            attributes[columnZeroBasedOrdinalIndex] = CONTENT_FIELD_NODE_MAPPER.mapValueStringFieldDtoToContentFieldNode(f);
        }
        return ContainerView.forArray(attributes);
    }
}

