/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.gui.cssmapper;

import ch.nolix.core.web.cssmodel.CssProperty;
import ch.nolix.coreapi.web.cssmodel.ICssProperty;
import ch.nolix.system.gui.cssmapper.CssValueMapper;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.gui.box.Corner;
import ch.nolix.systemapi.gui.box.ICornerShadow;
import ch.nolix.systemapi.gui.cssmapper.ICssValueMapper;

public final class CornerShadowToCssMapperHelper {
    private static final ICssValueMapper CSS_VALUE_MAPPER = new CssValueMapper();

    private CornerShadowToCssMapperHelper() {
    }

    public static ICssProperty mapCornerShadowToCssPropertyWhenShadowIsInsideTheBox(ICornerShadow cornerShadow) {
        int side1Thickness = cornerShadow.getSide1Thickness();
        int side2Thickness = cornerShadow.getSide2Thickness();
        int blurRadius = cornerShadow.getBlurRadius();
        IColor color = cornerShadow.getColor();
        String colorCssValue = CSS_VALUE_MAPPER.mapColorToCssValue(color);
        return switch (cornerShadow.getCorner()) {
            case Corner.BOTTOM_LEFT -> CssProperty.withNameAndValue("box-shadow", String.format("%dpx %dpx %dpx %s inset", side1Thickness, -side2Thickness, blurRadius, colorCssValue));
            case Corner.BOTTOM_RIGHT -> CssProperty.withNameAndValue("box-shadow", String.format("%dpx %dpx %dpx %s inset", -side1Thickness, -side2Thickness, blurRadius, colorCssValue));
            case Corner.TOP_LEFT -> CssProperty.withNameAndValue("box-shadow", String.format("%dpx %dpx %dpx %s inset", side1Thickness, side2Thickness, blurRadius, colorCssValue));
            case Corner.TOP_RIGHT -> CssProperty.withNameAndValue("box-shadow", String.format("%dpx %dpx %dpx %s inset", -side1Thickness, side2Thickness, blurRadius, colorCssValue));
            default -> throw new MatchException(null, null);
        };
    }

    public static ICssProperty mapCornerShadowToCssPropertyWhenShadowIsOutsideTheBox(ICornerShadow cornerShadow) {
        int side1Thickness = cornerShadow.getSide1Thickness();
        int side2Thickness = cornerShadow.getSide2Thickness();
        int blurRadius = cornerShadow.getBlurRadius();
        IColor color = cornerShadow.getColor();
        String colorCssValue = CSS_VALUE_MAPPER.mapColorToCssValue(color);
        return switch (cornerShadow.getCorner()) {
            case Corner.BOTTOM_LEFT -> CssProperty.withNameAndValue("box-shadow", String.format("%dpx %dpx %dpx %s", -side1Thickness, side2Thickness, blurRadius, colorCssValue));
            case Corner.BOTTOM_RIGHT -> CssProperty.withNameAndValue("box-shadow", String.format("%dpx %dpx %dpx %s", side1Thickness, side2Thickness, blurRadius, colorCssValue));
            case Corner.TOP_LEFT -> CssProperty.withNameAndValue("box-shadow", String.format("%dpx %dpx %dpx %s", -side1Thickness, -side2Thickness, blurRadius, colorCssValue));
            case Corner.TOP_RIGHT -> CssProperty.withNameAndValue("box-shadow", String.format("%dpx %dpx %dpx %s", side1Thickness, -side2Thickness, blurRadius, colorCssValue));
            default -> throw new MatchException(null, null);
        };
    }
}

