/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.graphic.image;

import ch.nolix.core.container.matrix.Matrix;
import ch.nolix.core.environment.runningjar.RunningJar;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.base.AbstractElement;
import ch.nolix.system.graphic.image.MutableImage;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.graphic.image.IImage;
import ch.nolix.systemapi.graphic.image.IMutableImage;
import java.awt.image.BufferedImage;

public final class Image
extends AbstractElement
implements IImage {
    private final MutableImage internalImage;

    private Image(MutableImage internalImage) {
        Validator.assertThat(internalImage).thatIsNamed("internal image").isNotNull();
        this.internalImage = internalImage;
    }

    public static Image fromAnyImage(IImage image) {
        if (image instanceof Image) {
            Image lImage = (Image)image;
            return lImage;
        }
        return new Image(MutableImage.fromAnyImage(image));
    }

    public static Image fromBytes(byte[] bytes) {
        MutableImage mutableImage = MutableImage.fromBytes(bytes);
        return Image.fromAnyImage(mutableImage);
    }

    public static Image fromFile(String filePath) {
        return new Image(MutableImage.fromFile(filePath));
    }

    public static Image fromResource(String path) {
        return new Image(MutableImage.fromBytes(RunningJar.getResourceAsBytes(path)));
    }

    public static Image fromSpecification(INode<?> specification) {
        return new Image(MutableImage.fromSpecification(specification));
    }

    public static Image withPixels(Matrix<IColor> pixels) {
        return new Image(MutableImage.withPixels(pixels));
    }

    @Override
    public IContainer<INode<?>> getAttributes() {
        return this.internalImage.getAttributes();
    }

    @Override
    public IColor getBottomLeftPixel() {
        return this.internalImage.getBottomLeftPixel();
    }

    @Override
    public IColor getBottomRightPixel() {
        return this.internalImage.getBottomRightPixel();
    }

    @Override
    public int getHeight() {
        return this.internalImage.getHeight();
    }

    @Override
    public IColor getPixel(int xPosition, int yPosition) {
        return this.internalImage.getPixel(xPosition, yPosition);
    }

    @Override
    public int getPixelCount() {
        return this.internalImage.getPixelCount();
    }

    public Matrix<IColor> getPixels() {
        return this.internalImage.getPixels();
    }

    public MutableImage getSection(int xPosition, int yPosition, int width, int height) {
        return this.internalImage.getSection(xPosition, yPosition, width, height);
    }

    @Override
    public IColor getTopLeftPixel() {
        return this.internalImage.getTopLeftPixel();
    }

    @Override
    public IColor getTopRightPixel() {
        return this.internalImage.getTopRightPixel();
    }

    @Override
    public int getWidth() {
        return this.internalImage.getWidth();
    }

    @Override
    public String toBase64Jpg() {
        return this.internalImage.toBase64Jpg();
    }

    @Override
    public String toBase64Png() {
        return this.internalImage.toBase64Png();
    }

    @Override
    public BufferedImage toBufferedImage() {
        return this.internalImage.toBufferedImage();
    }

    @Override
    public Image toImmutableImage() {
        return this;
    }

    @Override
    public byte[] toJpg() {
        return this.internalImage.toJpg();
    }

    public MutableImage toLeftRotatedImage() {
        return this.internalImage.toLeftRotatedImage();
    }

    public MutableImage toMutableImage() {
        return this.internalImage.getCopy();
    }

    @Override
    public byte[] toPng() {
        return this.internalImage.toPng();
    }

    public MutableImage toRepeatedImage(int width, int height) {
        return this.internalImage.toRepeatedImage(width, height);
    }

    public MutableImage toRightRotatedImage() {
        return this.internalImage.toRightRotatedImage();
    }

    public MutableImage toScaledImage(double factor) {
        return this.internalImage.toScaledImage(factor);
    }

    public MutableImage toScaledImage(double widthFactor, double heightFactor) {
        return this.internalImage.toScaledImage(widthFactor, heightFactor);
    }

    @Override
    public IMutableImage<?> withAlphaValue(double alphaValue) {
        return this.internalImage.withAlphaValue(alphaValue);
    }

    @Override
    public IMutableImage<?> withWidthAndHeight(int width, int height) {
        return this.internalImage.withWidthAndHeight(width, height);
    }
}

