/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.property;

import ch.nolix.core.document.node.Node;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.property.AbstractSingleValue;
import java.util.function.Consumer;
import java.util.function.Function;

public final class Value<V>
extends AbstractSingleValue<V> {
    public Value(String name, Consumer<V> setterMethod, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator) {
        super(name, setterMethod, valueCreator, specificationCreator);
    }

    public static Value<Boolean> forBoolean(String name, Consumer<Boolean> setterMethod) {
        return new Value<Boolean>(name, setterMethod, INode::getSingleChildNodeAsBoolean, Node::withChildNode);
    }

    public static Value<Integer> forInt(String name, Consumer<Integer> setterMethod) {
        return new Value<Integer>(name, setterMethod, INode::getSingleChildNodeAsInt, Node::withChildNode);
    }

    public static Value<String> forString(String name, Consumer<String> setterMethod) {
        return new Value<String>(name, setterMethod, s -> s.getStoredSingleChildNode().getHeaderOrEmptyString(), Value::getStringValueSpecificationForAValueFromString);
    }

    private static Node getStringValueSpecificationForAValueFromString(String string) {
        if (string.isEmpty()) {
            return Node.EMPTY_NODE;
        }
        return Node.withChildNode(string, new String[0]);
    }

    @Override
    public boolean isMutable() {
        return false;
    }
}

