/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.property;

import ch.nolix.core.document.node.Node;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.property.AbstractSingleValue;
import java.util.function.Consumer;
import java.util.function.Function;

public final class OptionalValue<V>
extends AbstractSingleValue<V> {
    public OptionalValue(String name, Consumer<V> setterMethod, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator) {
        super(name, setterMethod, valueCreator, specificationCreator);
    }

    public static OptionalValue<Boolean> forBoolean(String name, Consumer<Boolean> setterMethod) {
        return new OptionalValue<Boolean>(name, setterMethod, INode::getSingleChildNodeAsBoolean, Node::withChildNode);
    }

    public static OptionalValue<Double> forDouble(String name, Consumer<Double> setterMethod) {
        return new OptionalValue<Double>(name, setterMethod, INode::getSingleChildNodeAsDouble, Node::withChildNode);
    }

    public static OptionalValue<Integer> forInt(String name, Consumer<Integer> setterMethod) {
        return new OptionalValue<Integer>(name, setterMethod, INode::getSingleChildNodeAsInt, Node::withChildNode);
    }

    public static OptionalValue<String> forString(String name, Consumer<String> setterMethod) {
        return new OptionalValue<String>(name, setterMethod, s -> s.getStoredSingleChildNode().getHeaderOrEmptyString(), s -> {
            if (s.isEmpty()) {
                return Node.EMPTY_NODE;
            }
            return Node.withChildNode(s, new String[0]);
        });
    }

    @Override
    public boolean isMutable() {
        return false;
    }
}

