/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.property;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.attribute.mandatoryattribute.INameHolder;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.systemapi.element.property.IProperty;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class MultiValueExtractor<V>
implements IProperty,
INameHolder {
    private final String name;
    private final Consumer<V> adder;
    private final Supplier<IContainer<V>> getter;
    private final Function<INode<?>, V> valueCreator;
    private final Function<V, INode<?>> specificationCreator;

    public MultiValueExtractor(String name, Consumer<V> adder, Supplier<IContainer<V>> getter, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator) {
        Validator.assertThat(name).thatIsNamed("Name").isNotBlank();
        Validator.assertThat(adder).thatIsNamed("adder").isNotNull();
        Validator.assertThat(getter).thatIsNamed("getter").isNotNull();
        Validator.assertThat(valueCreator).thatIsNamed("value creator").isNotNull();
        Validator.assertThat(specificationCreator).thatIsNamed("specification creator").isNotNull();
        this.name = name;
        this.adder = adder;
        this.getter = getter;
        this.valueCreator = valueCreator;
        this.specificationCreator = specificationCreator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean addedOrChangedAttribute(INode<?> attribute) {
        if (attribute.hasHeader(this.getName())) {
            this.adder.accept(this.valueCreator.apply(attribute));
            return true;
        }
        return false;
    }

    @Override
    public void fillUpAttributesInto(ILinkedList<INode<?>> list) {
        for (Object v : this.getter.get()) {
            list.addAtEnd(this.specificationCreator.apply(v));
        }
    }
}

