/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.property;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.attribute.mandatoryattribute.INameHolder;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.systemapi.element.property.IProperty;
import java.util.function.Consumer;
import java.util.function.Function;

public final class CatchingProperty<V>
implements IProperty,
INameHolder {
    private final String name;
    private final Consumer<V> setter;
    private final Function<INode<?>, V> valueCreator;

    public CatchingProperty(String name, Consumer<V> setter, Function<INode<?>, V> valueCreator) {
        Validator.assertThat(name).thatIsNamed("name").isNotBlank();
        Validator.assertThat(setter).thatIsNamed("setter").isNotNull();
        Validator.assertThat(valueCreator).thatIsNamed("value creator").isNotNull();
        this.name = name;
        this.setter = setter;
        this.valueCreator = valueCreator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean addedOrChangedAttribute(INode<?> attribute) {
        if (this.hasName(attribute.getHeader())) {
            this.setter.accept(this.valueCreator.apply(attribute));
            return true;
        }
        return false;
    }

    @Override
    public void fillUpAttributesInto(ILinkedList<INode<?>> list) {
    }
}

