/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.multistateconfiguration;

import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.multistateconfiguration.AbstractMaterializedProperty;
import ch.nolix.system.element.multistateconfiguration.State;
import ch.nolix.system.element.multistateconfiguration.StateProperty;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class CascadingProperty<S extends Enum<S>, V>
extends AbstractMaterializedProperty<S, V> {
    private final V defaultValue;
    private CascadingProperty<S, V> parentProperty;

    public CascadingProperty(String name, Class<S> stateClass, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator, V defaultValue) {
        super(name, stateClass, valueCreator, specificationCreator);
        Validator.assertThat(defaultValue).thatIsNamed("default value").isNotNull();
        this.defaultValue = defaultValue;
    }

    public CascadingProperty(String name, Class<S> stateClass, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator, BiConsumer<S, V> setterMethod, V defaultValue) {
        super(name, stateClass, valueCreator, specificationCreator, setterMethod);
        Validator.assertThat(defaultValue).thatIsNamed("default value").isNotNull();
        this.defaultValue = defaultValue;
    }

    public static <S2 extends Enum<S2>> CascadingProperty<S2, Boolean> forBooleanWithNameAndStateClassAndDefaultValue(String name, Class<S2> stateClass, boolean defaultValue) {
        return new CascadingProperty<S2, Boolean>(name, stateClass, INode::getSingleChildNodeAsBoolean, Node::withChildNode, defaultValue);
    }

    public static <S2 extends Enum<S2>> CascadingProperty<S2, Integer> forIntWithNameAndStateClassAndSetterMethodAndDefaultValue(String name, Class<S2> stateClass, BiConsumer<S2, Integer> setterMethod, int defaultValue) {
        return new CascadingProperty<S2, Integer>(name, stateClass, INode::getSingleChildNodeAsInt, Node::withChildNode, setterMethod, defaultValue);
    }

    @Override
    protected V getValueWhenHasState(State<S> state) {
        StateProperty stateProperty = this.stateProperties[state.getIndex()];
        if (stateProperty.hasValueOrDefinesEmpty()) {
            return stateProperty.getValue();
        }
        StateProperty baseStateProperty = this.getStoredBaseStateProperty();
        if (baseStateProperty.hasValueOrDefinesEmpty()) {
            return baseStateProperty.getValue();
        }
        if (this.hasParentProperty()) {
            return this.parentProperty.getValueWhenHasState(state);
        }
        return this.defaultValue;
    }

    @Override
    protected boolean hasValueWhenHasState(State<S> state) {
        StateProperty stateProperty = this.stateProperties[state.getIndex()];
        if (stateProperty.hasValueOrDefinesEmpty()) {
            return stateProperty.hasValue();
        }
        StateProperty baseStateProperty = this.getStoredBaseStateProperty();
        if (baseStateProperty.hasValueOrDefinesEmpty()) {
            return baseStateProperty.hasValue();
        }
        return this.hasParentProperty() && this.parentProperty.hasValueWhenHasState(state);
    }

    void setParentProperty(CascadingProperty<S, ?> parentProperty) {
        Validator.assertThat(parentProperty).thatIsNamed("parent property").isNotNull();
        this.parentProperty = parentProperty;
    }

    private boolean hasParentProperty() {
        return this.parentProperty != null;
    }
}

