/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.application.main;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.net.endpoint3.IDataProviderController;
import ch.nolix.system.application.main.AbstractClient;

final class ClientDataProviderController
implements IDataProviderController {
    private final AbstractClient<?> parentClient;

    public ClientDataProviderController(AbstractClient<?> parentClient) {
        Validator.assertThat(parentClient).thatIsNamed("parent client").isNotNull();
        this.parentClient = parentClient;
    }

    @Override
    public INode<?> getDataForRequest(IChainedNode request) {
        return this.parentClient.getDataFromHere(request);
    }

    public IContainer<INode<?>> getDataForRequests(IChainedNode ... requests) {
        ImmutableList<IChainedNode> concatenatedRequests = ImmutableList.withElements(requests);
        return this.getDataForRequests(concatenatedRequests);
    }

    public IContainer<INode<?>> getDataForRequests(Iterable<? extends IChainedNode> requests) {
        return ContainerView.forIterable(requests).to(this.parentClient::getDataFromHere);
    }

    @Override
    public void runCommand(IChainedNode command) {
        this.parentClient.runHere(command);
    }

    @Override
    public void runCommands(IChainedNode ... commands) {
        IChainedNode[] iChainedNodeArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            IChainedNode c = iChainedNodeArray[n2];
            this.parentClient.runHere(c);
            ++n2;
        }
    }

    @Override
    public void runCommands(Iterable<? extends IChainedNode> commands) {
        for (IChainedNode iChainedNode : commands) {
            this.parentClient.runHere(iChainedNode);
        }
    }
}

