/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.application.main;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentBelongsToParentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotBelongToParentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentHasAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.target.ApplicationInstanceTarget;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.core.reflection.reflectiontool.ReflectionTool;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.coreapi.net.endpoint3.IEndPoint;
import ch.nolix.coreapi.net.target.IApplicationInstanceTarget;
import ch.nolix.coreapi.net.target.IServerTarget;
import ch.nolix.system.application.main.AbstractBackendClient;
import ch.nolix.system.application.main.AbstractClient;
import ch.nolix.system.application.main.AbstractServer;
import ch.nolix.system.application.main.AbstractSession;
import ch.nolix.systemapi.application.main.IApplication;
import java.util.Locale;

public abstract class Application<C extends AbstractBackendClient<C, S>, S>
implements IApplication<C, S> {
    private String instanceAddendix;
    private AbstractServer<?> parentServer;
    private final S applicationService;
    private final ILinkedList<C> clients = LinkedList.createEmpty();

    protected Application(S applicationService) {
        Validator.assertThat(applicationService).thatIsNamed("application service").isNotNull();
        this.applicationService = applicationService;
    }

    @Override
    public final IApplicationInstanceTarget asTarget() {
        IServerTarget serverTarget = this.getStoredParentServer().asTarget();
        return this.asTargetWithServerTarget(serverTarget);
    }

    @Override
    public final boolean belongsToServer() {
        return this.parentServer != null;
    }

    @Override
    public final Class<C> getClientClass() {
        return this.createInitialSession().getClientClass();
    }

    @Override
    public final String getInstanceAppendix() {
        this.assertHasNameAddendum();
        return this.instanceAddendix;
    }

    @Override
    public final String getInstanceName() {
        if (!this.hasInstanceAppendix()) {
            return this.getApplicationName();
        }
        return String.format("%s %s", this.getApplicationName(), this.getInstanceAppendix());
    }

    @Override
    public final S getStoredApplicationService() {
        return this.applicationService;
    }

    public final IContainer<C> getStoredClients() {
        this.removeClosedClients();
        return this.clients;
    }

    @Override
    public final String getUrlInstanceName() {
        return this.getInstanceName().replace(" ", "_").toLowerCase(Locale.ENGLISH);
    }

    @Override
    public final boolean hasClientConnected() {
        return this.getStoredClients().containsAny();
    }

    @Override
    public final boolean hasInstanceAppendix() {
        return this.instanceAddendix != null;
    }

    final void takeClient(AbstractBackendClient<?, ?> client) {
        AbstractBackendClient<?, ?> localClient = client;
        localClient.internalSetParentApplication(this);
        this.clients.addAtEnd(localClient);
        FlowController.runInBackground(() -> localClient.internalPush(this.createInitialSession()));
    }

    final void takeEndPoint(IEndPoint endPoint) {
        this.takeClient((AbstractBackendClient<?, ?>)this.createBackendClientWithEndPoint(endPoint));
    }

    protected abstract Class<?> getInitialSessionClass();

    final void setNameAppendix(String nameAddendix) {
        Validator.assertThat(nameAddendix).thatIsNamed("instance name").isNotBlank();
        this.assertDoesNotHaveNameAddendum();
        this.instanceAddendix = nameAddendix;
    }

    final void setParentServer(AbstractServer<?> parentServer) {
        Validator.assertThat(parentServer).thatIsNamed("parent server").isNotNull();
        this.assertDoesNotBelongToServer();
        this.parentServer = parentServer;
    }

    private void assertBelongsToServer() {
        if (!this.belongsToServer()) {
            throw ArgumentDoesNotBelongToParentException.forArgumentAndParentType(this, AbstractServer.class);
        }
    }

    private void assertDoesNotBelongToServer() {
        if (this.belongsToServer()) {
            throw ArgumentBelongsToParentException.forArgumentAndParent(this, this.getStoredParentServer());
        }
    }

    private void assertDoesNotHaveNameAddendum() {
        if (this.hasInstanceAppendix()) {
            throw ArgumentHasAttributeException.forArgumentAndAttributeName(this, "instance name");
        }
    }

    private void assertHasNameAddendum() {
        if (!this.hasInstanceAppendix()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "name addendum");
        }
    }

    private IApplicationInstanceTarget asTargetWithServerTarget(IServerTarget serverTarget) {
        return ApplicationInstanceTarget.forIpOrDomainAndPortAndApplicationInstanceNameAndApplicationUrlInstanceNameAndSecurityModeForConnections(serverTarget.getIpOrDomain(), serverTarget.getPort(), this.getInstanceName(), this.getUrlInstanceName(), serverTarget.getSecurityModeForConnection());
    }

    private C createBackendClientWithEndPoint(IEndPoint endPoint) {
        AbstractBackendClient backendClient = (AbstractBackendClient)ReflectionTool.createInstanceFromDefaultConstructorOfClass(this.getClientClass());
        backendClient.setEndPoint(endPoint);
        return (C)backendClient;
    }

    private AbstractSession<C, S> createInitialSession() {
        return (AbstractSession)ReflectionTool.createInstanceFromDefaultConstructorOfClass(this.getInitialSessionClass());
    }

    private AbstractServer<?> getStoredParentServer() {
        this.assertBelongsToServer();
        return this.parentServer;
    }

    private void removeClosedClients() {
        this.clients.removeAll(AbstractClient::isClosed);
    }
}

