/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.web.htmlelementmodel;

import ch.nolix.coreapi.web.htmlelementmodel.IHtmlElement;

public final class HtmlElementStringRepresentator {
    public String toString(IHtmlElement htmlElement) {
        if (!htmlElement.containsChildElements()) {
            return this.toStringWhenDoesNotContainChildElements(htmlElement);
        }
        return this.toStringWhenContainsChildElements(htmlElement);
    }

    private String toStringWhenDoesNotContainChildElements(IHtmlElement htmlElement) {
        if (htmlElement.getInnerText().isEmpty()) {
            return this.toStringWhenDoesNotContainChildElementsAndHasEmptyInnerText(htmlElement);
        }
        return this.toStringWhenDoesNotContainChildElementsAndHasNonEmptyInnerText(htmlElement);
    }

    private String toStringWhenDoesNotContainChildElementsAndHasEmptyInnerText(IHtmlElement htmlElement) {
        if (!htmlElement.containsAttributes()) {
            return "<" + htmlElement.getType() + " />";
        }
        return "<" + htmlElement.getType() + " " + this.getAttributesAsString(htmlElement) + " />";
    }

    private String toStringWhenDoesNotContainChildElementsAndHasNonEmptyInnerText(IHtmlElement htmlElement) {
        if (!htmlElement.containsAttributes()) {
            return "<" + htmlElement.getType() + ">" + htmlElement.getInnerText() + "</" + htmlElement.getType() + ">";
        }
        return "<" + htmlElement.getType() + " " + this.getAttributesAsString(htmlElement) + ">" + htmlElement.getInnerText() + "</" + htmlElement.getType() + ">";
    }

    private String toStringWhenContainsChildElements(IHtmlElement htmlElement) {
        if (htmlElement.getInnerText().isEmpty()) {
            return this.toStringWhenContainsChildElementsAndHasEmptyInnerText(htmlElement);
        }
        return this.toStringWhenContainsChildElementsAndHasNonEmptyInnerText(htmlElement);
    }

    private String toStringWhenContainsChildElementsAndHasEmptyInnerText(IHtmlElement htmlElement) {
        if (!htmlElement.containsAttributes()) {
            return "<" + htmlElement.getType() + ">" + this.getChildElementsAsString(htmlElement) + "</" + htmlElement.getType() + ">";
        }
        return "<" + htmlElement.getType() + " " + this.getAttributesAsString(htmlElement) + ">" + this.getChildElementsAsString(htmlElement) + "</" + htmlElement.getType() + ">";
    }

    private String toStringWhenContainsChildElementsAndHasNonEmptyInnerText(IHtmlElement htmlElement) {
        if (!htmlElement.containsAttributes()) {
            return "<" + htmlElement.getType() + ">" + htmlElement.getInnerText() + this.getChildElementsAsString(htmlElement) + "</" + htmlElement.getType() + ">";
        }
        return "<" + htmlElement.getType() + " " + this.getAttributesAsString(htmlElement) + ">" + htmlElement.getInnerText() + this.getChildElementsAsString(htmlElement) + "</" + htmlElement.getType() + ">";
    }

    private String getChildElementsAsString(IHtmlElement htmlElement) {
        return htmlElement.getChildElements().toStringWithSeparator("");
    }

    private String getAttributesAsString(IHtmlElement htmlElement) {
        return htmlElement.getAttributes().toStringWithSeparator(" ");
    }
}

