/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.sql.connection;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.core.sql.model.SqlRecord;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.coreapi.sql.connection.ISqlConnection;
import ch.nolix.coreapi.sql.model.ISqlRecord;
import ch.nolix.coreapi.sql.sqlproperty.SqlDatabaseEngine;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;

public abstract class AbstractSqlConnection
implements ISqlConnection {
    private final SqlDatabaseEngine sqlDatabaseEngine;
    private final Connection connection;
    private final ICloseController closeController = CloseController.forElement(this);

    protected AbstractSqlConnection(SqlDatabaseEngine sqlDatabaseEngine, Connection connection) {
        Validator.assertThat(sqlDatabaseEngine).thatIsNamed(SqlDatabaseEngine.class).isNotNull();
        Validator.assertThat(connection).thatIsNamed(Connection.class).isNotNull();
        this.sqlDatabaseEngine = sqlDatabaseEngine;
        this.connection = connection;
    }

    protected AbstractSqlConnection(SqlDatabaseEngine sqlDatabaseEngine, int port, String userName, String userPassword) {
        this(sqlDatabaseEngine, "127.0.0.1", port, userName, userPassword);
    }

    protected AbstractSqlConnection(SqlDatabaseEngine sqlDatabaseEngine, String ip, int port, String userName, String userPassword) {
        Validator.assertThat(sqlDatabaseEngine).thatIsNamed(SqlDatabaseEngine.class).isNotNull();
        this.sqlDatabaseEngine = sqlDatabaseEngine;
        this.registerSqlDatabaseEngineDriver();
        Properties properties = new Properties();
        properties.put("user", userName);
        properties.put("password", userPassword);
        properties.put("encrypt", "true");
        properties.put("trustServerCertificate", "true");
        try {
            this.connection = DriverManager.getConnection("jdbc:sqlserver://" + ip + ":" + port, properties);
        }
        catch (SQLException sqlException) {
            throw WrapperException.forError(sqlException);
        }
    }

    @Override
    public final void executeStatements(IContainer<String> statements) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement statement = this.connection.createStatement();){
                this.connection.setAutoCommit(false);
                for (String sqlStatement : statements) {
                    statement.addBatch(sqlStatement);
                }
                statement.executeBatch();
                this.connection.commit();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sqlException) {
            try {
                this.connection.rollback();
            }
            catch (SQLException sqlException2) {
                throw WrapperException.forError(sqlException2);
            }
            throw WrapperException.forError(sqlException);
        }
    }

    @Override
    public final void executeStatement(String statement, String ... statements) {
        ContainerView<String> allStatements = ContainerView.forElementAndArray(statement, statements);
        this.executeStatements(allStatements);
    }

    @Override
    public final SqlDatabaseEngine getDatabaseEngine() {
        return this.sqlDatabaseEngine;
    }

    @Override
    public final IContainer<ISqlRecord> getRecordsFromQuery(String query) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement statement = this.connection.createStatement();){
                return this.getRecordsFromStatement(query, statement);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sqlException) {
            throw WrapperException.forError(sqlException);
        }
    }

    @Override
    public final ISqlRecord getSingleRecordFromQuery(String query) {
        return (ISqlRecord)this.getRecordsFromQuery(query).getStoredOne();
    }

    @Override
    public final ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public final void noteClose() {
        try {
            this.connection.close();
        }
        catch (SQLException sqlException) {
            throw WrapperException.forError(sqlException);
        }
    }

    protected abstract String getSqlDatabaseEngineDriverClass();

    private IContainer<ISqlRecord> getRecordsFromStatement(String query, Statement statement) throws SQLException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ResultSet resultSet = statement.executeQuery(query);){
            return this.getRecordsFromResultSet(resultSet);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private final IContainer<ISqlRecord> getRecordsFromResultSet(ResultSet resultSet) throws SQLException {
        LinkedList<ISqlRecord> sqlRecords = LinkedList.createEmpty();
        int columnCount = resultSet.getMetaData().getColumnCount();
        int index = 1;
        while (resultSet.next()) {
            List<String> entries = List.of();
            int i = 1;
            while (i <= columnCount) {
                String entry = resultSet.getString(i);
                entries.add(entry);
                ++i;
            }
            SqlRecord sqlRecord = SqlRecord.withOneBasedIndexAndValues(index, entries);
            sqlRecords.addAtEnd(sqlRecord);
            ++index;
        }
        return sqlRecords;
    }

    private void registerSqlDatabaseEngineDriver() {
        try {
            Class.forName(this.getSqlDatabaseEngineDriverClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw WrapperException.forError(classNotFoundException);
        }
    }
}

