/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.resourcecontrol.resourcepool;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.core.resourcecontrol.resourcepool.AbstractWrapperResource;
import ch.nolix.coreapi.resourcecontrol.closecontroller.Closeable;
import ch.nolix.coreapi.resourcecontrol.closecontroller.GroupCloseable;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.coreapi.resourcecontrol.resourcepool.IResourcePool;

public abstract class AbstractResourcePool<W extends AbstractWrapperResource<W, R>, R extends GroupCloseable>
implements IResourcePool<W> {
    private final ICloseController closeController = CloseController.forElement(this);
    private final LinkedList<R> resources = LinkedList.createEmpty();
    private final LinkedList<R> availableResources = LinkedList.createEmpty();

    @Override
    public final synchronized W borrowResource() {
        R resource = this.provideResource();
        return this.createWrapperResourceWithCurrentResourcePoolAndResource(resource);
    }

    @Override
    public final ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public final synchronized void noteClose() {
        this.resources.forEach(Closeable::close);
    }

    protected abstract R createResource();

    protected abstract W createWrapperResourceWithResource(R var1);

    final synchronized void internalTakeBackResource(R resource) {
        if (resource.isOpen()) {
            this.availableResources.addAtEnd(resource);
        }
    }

    private W createWrapperResourceWithCurrentResourcePoolAndResource(R resource) {
        W wrapperResource = this.createWrapperResourceWithResource(resource);
        ((AbstractWrapperResource)wrapperResource).internalSetParentResourcePool(this);
        return wrapperResource;
    }

    private R provideNewResource() {
        R resource = this.createResource();
        this.resources.addAtEnd(resource);
        return resource;
    }

    private R provideResource() {
        if (this.availableResources.containsAny()) {
            return (R)((GroupCloseable)this.availableResources.removeAndGetStoredLast());
        }
        return this.provideNewResource();
    }
}

