/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.resourcecontrol.closecontroller;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.ClosePool;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.programcontrol.processproperty.CloseState;
import ch.nolix.coreapi.resourcecontrol.closecontroller.GroupCloseable;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.coreapi.resourcecontrol.closecontroller.IClosePool;

public final class CloseController
implements ICloseController {
    private IClosePool parentClosePool;

    private CloseController(GroupCloseable element) {
        this.parentClosePool = new ClosePool(element);
    }

    public static CloseController forElement(GroupCloseable element) {
        return new CloseController(element);
    }

    @Override
    public void close() {
        this.parentClosePool.closeElementsIfStateIsOpen();
    }

    @Override
    public void createCloseDependencyTo(GroupCloseable element) {
        IContainer<GroupCloseable> elementsToAdd = element.getStoredCloseController().getParentClosePool().getStoredElements();
        for (GroupCloseable e : elementsToAdd) {
            e.getStoredCloseController().setParentClosePool(this.parentClosePool);
        }
        this.parentClosePool.addElements(elementsToAdd);
    }

    @Override
    public IClosePool getParentClosePool() {
        return this.parentClosePool;
    }

    @Override
    public boolean hasClosed() {
        return this.parentClosePool.getState() == CloseState.CLOSED;
    }

    @Override
    public void setParentClosePool(IClosePool parentClosePool) {
        Validator.assertThat(parentClosePool).thatIsNamed("parent ClosePool").isNotNull();
        this.parentClosePool = parentClosePool;
    }
}

