/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.flowcontrol;

import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.validator.Validator;

final class Waiter {
    private Waiter() {
    }

    public static void waitForSeconds(int duractionInSeconds) {
        Validator.assertThat(duractionInSeconds).thatIsNamed("duration in seconds").isNotNegative();
        Waiter.waitForMilliseconds(1000 * duractionInSeconds);
    }

    public static void waitForMilliseconds(int durationInMilliseconds) {
        Validator.assertThat(durationInMilliseconds).thatIsNamed("duration in milliseconds").isNotNegative();
        try {
            Thread.sleep(durationInMilliseconds);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw WrapperException.forError(interruptedException);
        }
    }
}

