/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.flowcontrol;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.core.programcontrol.flowcontrol.JobExecutor;
import ch.nolix.core.programcontrol.future.AbstractFuture;

public final class Future
extends AbstractFuture {
    private final JobExecutor jobExecutor;

    private Future(JobExecutor jobExecutor) {
        Validator.assertThat(jobExecutor).isNotNull();
        this.jobExecutor = jobExecutor;
    }

    public static Future forJobExecturor(JobExecutor jobExecutor) {
        return new Future(jobExecutor);
    }

    @Override
    public boolean caughtError() {
        return this.jobExecutor.caughtError();
    }

    @Override
    public Throwable getError() {
        return this.jobExecutor.getError();
    }

    public int getFinishedJobCount() {
        return this.jobExecutor.getFinishedJobCount();
    }

    @Override
    public boolean isFinished() {
        return this.jobExecutor.isFinished();
    }

    @Override
    public void waitUntilIsFinished() {
        FlowController.waitUntil(this::isFinished);
    }

    @Override
    public void waitUntilIsFinished(int timeoutInMilliseconds) {
        long startTimeInMilliseconds = System.currentTimeMillis();
        FlowController.asLongAs(() -> System.currentTimeMillis() - startTimeInMilliseconds < (long)timeoutInMilliseconds && this.isRunning());
        if (!this.isFinished()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "reached timeout before having finished");
        }
    }
}

