/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.flowcontrol;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.flowcontrol.AfterEveryMediator;
import ch.nolix.core.programcontrol.flowcontrol.Future;
import ch.nolix.core.programcontrol.flowcontrol.JobExecutor;
import ch.nolix.coreapi.programcontrol.flowcontrol.IAfterEveryMediator;
import ch.nolix.coreapi.programcontrol.flowcontrol.IAsLongAsMediator;
import ch.nolix.coreapi.programcontrol.future.IFuture;
import java.util.function.BooleanSupplier;

public final class AsLongAsMediator
implements IAsLongAsMediator {
    private final BooleanSupplier condition;

    private AsLongAsMediator(BooleanSupplier condition) {
        Validator.assertThat(condition).thatIsNamed("condition").isNotNull();
        this.condition = condition;
    }

    public static AsLongAsMediator withCondition(BooleanSupplier condition) {
        return new AsLongAsMediator(condition);
    }

    @Override
    public IAfterEveryMediator afterEveryMilliseconds(int timeIntervalInMilliseconds) {
        return new AfterEveryMediator(this.condition, timeIntervalInMilliseconds);
    }

    @Override
    public IAfterEveryMediator afterEverySecond() {
        return this.afterEveryMilliseconds(1000);
    }

    @Override
    public void run(Runnable job) {
        while (this.condition.getAsBoolean()) {
            job.run();
        }
    }

    @Override
    public IFuture runInBackground(Runnable job) {
        return Future.forJobExecturor(new JobExecutor(job, this.condition));
    }
}

