/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.flowcontrol;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.flowcontrol.Future;
import ch.nolix.core.programcontrol.flowcontrol.JobExecutor;
import ch.nolix.core.programcontrol.flowcontrol.Waiter;
import ch.nolix.coreapi.programcontrol.flowcontrol.IAfterEveryMediator;
import java.util.function.BooleanSupplier;

public final class AfterEveryMediator
implements IAfterEveryMediator {
    private final int timeIntervalInMilliseconds;
    private final Integer maxRunCount;
    private final BooleanSupplier condition;

    AfterEveryMediator(BooleanSupplier condition, int timeIntervalInMilliseconds) {
        Validator.assertThat(condition).thatIsNamed("condition").isNotNull();
        Validator.assertThat(timeIntervalInMilliseconds).thatIsNamed("time interval in milliseconds").isNotNegative();
        this.maxRunCount = null;
        this.condition = condition;
        this.timeIntervalInMilliseconds = timeIntervalInMilliseconds;
    }

    AfterEveryMediator(int maxRunCount, BooleanSupplier condition, int timeIntervalInMilliseconds) {
        Validator.assertThat(maxRunCount).thatIsNamed("max run count").isNotNegative();
        Validator.assertThat(condition).thatIsNamed("condition").isNotNull();
        Validator.assertThat(timeIntervalInMilliseconds).thatIsNamed("time interval in milliseconds").isNotNegative();
        this.maxRunCount = maxRunCount;
        this.condition = condition;
        this.timeIntervalInMilliseconds = timeIntervalInMilliseconds;
    }

    @Override
    public void run(Runnable job) {
        if (!this.hasMaxRunCount()) {
            this.runWhenDoesNotHaveMaxRunCount(job);
        } else {
            this.runWhenHasMaxRunCount(job);
        }
    }

    @Override
    public Future runInBackground(Runnable job) {
        if (!this.hasMaxRunCount()) {
            return this.runInBackgroundWhenDoesNotHaveMaxRunConunt(job);
        }
        return this.runInBackgroundWhenHasMaxRunConunt(job);
    }

    private void assertHasCondition() {
        if (!this.hasCondition()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "condition");
        }
    }

    private boolean hasCondition() {
        return this.condition != null;
    }

    private boolean hasMaxRunCount() {
        return this.maxRunCount != null;
    }

    private Future runInBackgroundWhenDoesNotHaveMaxRunConunt(Runnable job) {
        if (!this.hasCondition()) {
            return Future.forJobExecturor(new JobExecutor(job, this.timeIntervalInMilliseconds, () -> true));
        }
        return Future.forJobExecturor(new JobExecutor(job, this.condition, this.timeIntervalInMilliseconds));
    }

    private Future runInBackgroundWhenHasMaxRunConunt(Runnable job) {
        if (!this.hasCondition()) {
            return Future.forJobExecturor(new JobExecutor(job, (int)this.maxRunCount, this.timeIntervalInMilliseconds));
        }
        return Future.forJobExecturor(new JobExecutor(job, this.maxRunCount, this.condition, this.timeIntervalInMilliseconds));
    }

    private void runWhenDoesNotHaveMaxRunCount(Runnable job) {
        Validator.assertThat(job).thatIsNamed("job").isNotNull();
        this.assertHasCondition();
        while (this.condition.getAsBoolean()) {
            job.run();
            Waiter.waitForMilliseconds(this.timeIntervalInMilliseconds);
        }
    }

    private void runWhenHasMaxRunCount(Runnable job) {
        Validator.assertThat(job).thatIsNamed("job").isNotNull();
        if (!this.hasCondition()) {
            int i = 1;
            while (i <= this.maxRunCount) {
                Waiter.waitForMilliseconds(this.timeIntervalInMilliseconds);
                job.run();
                ++i;
            }
        } else {
            int i = 1;
            while (i <= this.maxRunCount) {
                Waiter.waitForMilliseconds(this.timeIntervalInMilliseconds);
                if (this.condition.getAsBoolean()) {
                    job.run();
                    ++i;
                    continue;
                }
                break;
            }
        }
    }
}

