/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.target;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;
import ch.nolix.coreapi.net.target.IServerTarget;

public class ServerTarget
implements IServerTarget {
    private final String ipOrDomain;
    private final int port;
    private final SecurityMode securityModeForConnections;

    protected ServerTarget(String ipOrDomain, int port, SecurityMode securityModeForConnections) {
        Validator.assertThat(ipOrDomain).thatIsNamed("ip or address name").isNotBlank();
        Validator.assertThat(port).thatIsNamed("port").isPort();
        Validator.assertThat(securityModeForConnections).thatIsNamed("security mode for connections").isNotNull();
        this.ipOrDomain = ipOrDomain;
        this.port = port;
        this.securityModeForConnections = securityModeForConnections;
    }

    public static ServerTarget forIpOrDomainAndPortAndSecurityModeForConnections(String ipOrDomain, int port, SecurityMode securityModeForConnections) {
        return new ServerTarget(ipOrDomain, port, securityModeForConnections);
    }

    @Override
    public final String getIpOrDomain() {
        return this.ipOrDomain;
    }

    @Override
    public final int getPort() {
        return this.port;
    }

    @Override
    public final SecurityMode getSecurityModeForConnection() {
        return this.securityModeForConnections;
    }

    @Override
    public String toUrl() {
        return switch (this.getSecurityModeForConnection()) {
            case SecurityMode.NONE -> this.toHttpUrl();
            case SecurityMode.SSL -> this.toHttpsUrl();
            default -> throw new MatchException(null, null);
        };
    }

    private String toHttpsUrl() {
        if (this.getPort() == 443) {
            return String.format("https://%s", this.getIpOrDomain());
        }
        return String.format("https://%s:%s", this.getIpOrDomain(), this.getPort());
    }

    private String toHttpUrl() {
        if (this.getPort() == 80) {
            return String.format("http://%s", this.getIpOrDomain());
        }
        return String.format("http://%s:%s", this.getIpOrDomain(), this.getPort());
    }
}

