/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.target;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.target.ServerTarget;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;
import ch.nolix.coreapi.net.target.IApplicationInstanceTarget;

public class ApplicationInstanceTarget
extends ServerTarget
implements IApplicationInstanceTarget {
    private final String applicationInstanceName;
    private final String applicationUrlInstanceName;

    protected ApplicationInstanceTarget(String ipOrDomain, int port, String applicationInstanceName, String applicationUrlInstanceName, SecurityMode securityModeForConnections) {
        super(ipOrDomain, port, securityModeForConnections);
        Validator.assertThat(applicationInstanceName).thatIsNamed("application instance name").isNotBlank();
        Validator.assertThat(applicationUrlInstanceName).thatIsNamed("application url instance name").isNotBlank();
        this.applicationInstanceName = applicationInstanceName;
        this.applicationUrlInstanceName = applicationUrlInstanceName;
    }

    public static ApplicationInstanceTarget forIpOrDomainAndPortAndApplicationInstanceNameAndApplicationUrlInstanceNameAndSecurityModeForConnections(String ipOrDomain, int port, String applicationInstanceName, String applicationUrlInstanceName, SecurityMode securityModeForConnections) {
        return new ApplicationInstanceTarget(ipOrDomain, port, applicationInstanceName, applicationUrlInstanceName, securityModeForConnections);
    }

    @Override
    public final String getApplicationInstanceName() {
        return this.applicationInstanceName;
    }

    @Override
    public final String getApplicationUrlInstanceName() {
        return this.applicationUrlInstanceName;
    }

    @Override
    public String toUrl() {
        return super.toUrl() + "?app=" + this.getApplicationUrlInstanceName();
    }
}

