/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.http;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.commoncontainer.StoringRequestable;

public record HttpRequest(String content) {
    public static final String ACCEPT_HEADER = "Accept";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String HOST_HEADER = "Host";
    public static final String HTTP_HEADER = "HTTP";

    public static boolean canBe(StoringRequestable<String> lines) {
        return lines.containsAny(l -> l.contains(HTTP_HEADER)) && lines.containsAny(l -> l.contains(HOST_HEADER)) && lines.containsAny(l -> l.contains("Accept: text/html"));
    }

    public HttpRequest {
        Validator.assertThat(content).thatIsNamed("content").isNotBlank();
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public String toString() {
        return "HTTP\n";
    }
}

