/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint2;

import ch.nolix.core.net.endpoint2.AbstractServer;
import ch.nolix.core.net.endpoint2.ServerSlot;
import ch.nolix.coreapi.net.endpoint2.ISlot;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;

public final class Server
extends AbstractServer {
    private final ch.nolix.core.net.endpoint.Server internalServer;

    private Server(int port) {
        this.internalServer = ch.nolix.core.net.endpoint.Server.forPort(port);
        this.createCloseDependencyTo(this.internalServer);
    }

    private Server(int port, String httpMessage) {
        this.internalServer = ch.nolix.core.net.endpoint.Server.forPortAndInitialHttpMessage(port, httpMessage);
        this.createCloseDependencyTo(this.internalServer);
    }

    public static Server forPort(int port) {
        return new Server(port);
    }

    public static Server forPortAndHttpMessage(int port, String httpMessage) {
        return new Server(port, httpMessage);
    }

    public int getPort() {
        return this.internalServer.getPort();
    }

    @Override
    public SecurityMode getSecurityMode() {
        return SecurityMode.NONE;
    }

    @Override
    protected void noteAddedDefaultSlot(ISlot defaultSlot) {
        this.internalServer.addDefaultSlot(new ServerSlot(defaultSlot.getName(), this));
    }

    @Override
    protected void noteAddedSlot(ISlot slot) {
        this.internalServer.addSlot(new ServerSlot(slot.getName(), this));
    }

    @Override
    protected void noteRemovedSlot(ISlot slot) {
        this.internalServer.removeSlotByName(slot.getName());
    }
}

