/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint2;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.messaging.IndexedPackage;
import ch.nolix.coreapi.net.endpoint2protocol.MessageRole;

final class Package
extends IndexedPackage<String> {
    private final MessageRole messageRole;

    public Package(int index, MessageRole messageRole, String message) {
        super(index, message);
        Validator.assertThat(messageRole).isOfType(MessageRole.class);
        this.messageRole = messageRole;
    }

    public static Package createPackageFromString(String string) {
        return new Package(Integer.parseInt(string.substring(0, 8)), MessageRole.fromPrefix(string.charAt(8)), string.substring(9));
    }

    public MessageRole getMessageRole() {
        return this.messageRole;
    }

    public String toString() {
        return String.format("%08d%c%s", this.getIndex(), Character.valueOf(this.getMessageRole().getPrefix()), this.getStoredContent());
    }
}

