/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.validator;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.ArgumentMediator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public class MethodMediator
extends ArgumentMediator<Method> {
    protected MethodMediator(Method argument) {
        super("method", argument);
    }

    private MethodMediator(String argumentName, Method argument) {
        super(argumentName, argument);
    }

    public static MethodMediator forArgument(Method argument) {
        return new MethodMediator(argument);
    }

    public static MethodMediator forArgumentNameAndArgument(String argumentName, Method argument) {
        return new MethodMediator(argumentName, argument);
    }

    public final MethodMediator doesNotHaveAnnotations() {
        this.isNotNull();
        if (((Method)this.getStoredArgument()).getAnnotations().length != 0) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "has annotations");
        }
        return this;
    }

    public final MethodMediator doesNotReturnAnything() {
        this.isNotNull();
        if (((Method)this.getStoredArgument()).getReturnType() != Void.TYPE) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "returns something");
        }
        return this;
    }

    public final <A extends Annotation> MethodMediator hasAnnotation(Class<A> annotationType) {
        if (annotationType == null) {
            throw ArgumentIsNullException.forArgumentName("annotation type");
        }
        this.isNotNull();
        if (((Method)this.getStoredArgument()).getAnnotation(annotationType) == null) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "does not have the annotation '" + annotationType.getName() + "'");
        }
        return this;
    }

    public final MethodMediator hasParametersOfTypeOnly(Class<String> type) {
        if (type == null) {
            throw ArgumentIsNullException.forArgumentName(this.getArgumentName());
        }
        this.isNotNull();
        Parameter[] parameterArray = ((Method)this.getStoredArgument()).getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            if (!p.getType().isAssignableFrom(type)) {
                throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.getStoredArgument(), this.getArgumentName(), "has a parameter '" + p.getName() + "', that is not a " + type.getName());
            }
            ++n2;
        }
        return this;
    }

    public final MethodMediator hasReturnType(Class<?> returnType) {
        if (returnType == null) {
            throw ArgumentIsNullException.forArgumentName("return type");
        }
        Method argument = (Method)this.getStoredArgument();
        if (argument == null || argument.getReturnType() != returnType) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(argument, this.getArgumentName(), "does not have the return type '" + returnType.getName() + "'");
        }
        return this;
    }
}

