/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.validator;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsOutOfRangeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.BiggerArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.EqualArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NegativeArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NonNegativeArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NonPositiveArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.SmallerArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnequalArgumentException;
import ch.nolix.core.errorcontrol.validator.DoubleDeviationMediator;
import ch.nolix.core.errorcontrol.validator.Mediator;
import ch.nolix.core.independent.math.NumberComparator;

public class DoubleMediator
extends Mediator {
    private final double argument;

    protected DoubleMediator(double argument) {
        this.argument = argument;
    }

    protected DoubleMediator(String argumentName, double argument) {
        super(argumentName);
        this.argument = argument;
    }

    public static DoubleMediator forArgument(double argument) {
        return new DoubleMediator(argument);
    }

    public void isBetween(double min, double max) {
        if (this.argument < min || this.argument > max) {
            throw ArgumentIsOutOfRangeException.forArgumentAndArgumentNameAndRangeWithMinAndMax(this.argument, this.getArgumentName(), min, max);
        }
    }

    public void isBiggerThan(double value) {
        if (this.argument <= value) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.argument, this.getArgumentName(), "is not bigger than " + value);
        }
    }

    public void isEqualTo(double value) {
        if (!NumberComparator.areEqual(this.argument, value)) {
            throw UnequalArgumentException.forArgumentAndArgumentNameAndValue(this.argument, this.getArgumentName(), value);
        }
    }

    public void isNegative() {
        if (this.argument >= 0.0) {
            throw NonNegativeArgumentException.forArgumentAndArgumentName(this.argument, this.getArgumentName());
        }
    }

    public void isNotBiggerThan(double value) {
        if (this.argument > value) {
            throw BiggerArgumentException.forArgumentAndArgumentNameAndMax(this.argument, this.getArgumentName(), value);
        }
    }

    public void isNotEqualTo(double value) {
        if (NumberComparator.areEqual(this.argument, value)) {
            throw EqualArgumentException.forArgumentAndArgumentNameAndEqualValue(this.argument, this.getArgumentName(), value);
        }
    }

    public void isNotNegative() {
        if (this.argument < 0.0) {
            throw NegativeArgumentException.forArgumentAndArgumentName(this.argument, this.getArgumentName());
        }
    }

    public void isNotPositive() {
        if (this.argument <= 0.0) {
            throw NonPositiveArgumentException.forArgumentAndArgumentName(this.argument, this.getArgumentName());
        }
    }

    public void isNotSmallerThan(double value) {
        if (this.argument > value) {
            throw SmallerArgumentException.forArgumentNameAndArgumentAndLimit(this.argument, this.getArgumentName(), value);
        }
    }

    public void isPositive() {
        if (this.argument <= 0.0) {
            throw NonPositiveArgumentException.forArgumentAndArgumentName(this.argument, this.getArgumentName());
        }
    }

    public void isSmallerThan(double value) {
        if (this.argument >= value) {
            throw InvalidArgumentException.forArgumentAndArgumentNameAndErrorPredicate(this.argument, this.getArgumentName(), "is not smaller than " + value);
        }
    }

    public DoubleDeviationMediator withMaxDeviation(double maxDeviation) {
        return new DoubleDeviationMediator(this.getArgumentName(), this.getArgument(), maxDeviation);
    }

    protected double getArgument() {
        return this.argument;
    }
}

