/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.validator;

import ch.nolix.core.errorcontrol.invalidargumentexception.NegativeArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnequalArgumentException;
import ch.nolix.core.errorcontrol.validator.Mediator;

public final class DoubleDeviationMediator
extends Mediator {
    private final double argument;
    private final double maxDeviation;

    DoubleDeviationMediator(String argumentName, Double argument, double maxDeviation) {
        super(argumentName);
        if (maxDeviation < 0.0) {
            throw NegativeArgumentException.forArgumentAndArgumentName(maxDeviation, "max deviation");
        }
        this.argument = argument;
        this.maxDeviation = maxDeviation;
    }

    public void isEqualTo(double value) {
        if (Math.abs(value - this.argument) > this.maxDeviation) {
            throw UnequalArgumentException.forArgumentAndArgumentNameAndValue(value, this.getArgumentName(), this.argument);
        }
    }
}

