/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.invalidargumentexception;

import ch.nolix.core.errorcontrol.invalidargumentexception.AbstractInvalidArgumentException;
import ch.nolix.coreapi.errorcontrol.exceptionargumentbox.ErrorPredicateDto;

public final class ArgumentHasAttributeException
extends AbstractInvalidArgumentException {
    private ArgumentHasAttributeException(Object argument, String attributeName) {
        super(argument, new ErrorPredicateDto("has a " + ArgumentHasAttributeException.getValidatedAttributeNameFromAttributeName(attributeName)));
    }

    public static ArgumentHasAttributeException forArgumentAndAttributeName(Object argument, String attributeName) {
        return new ArgumentHasAttributeException(argument, attributeName);
    }

    private static String getValidatedAttributeNameFromAttributeName(String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("The given attribute name is null.");
        }
        if (attributeName.isBlank()) {
            throw new IllegalArgumentException("The given attribute name is blank.");
        }
        return attributeName;
    }
}

