/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.invalidargumentexception;

import ch.nolix.core.errorcontrol.invalidargumentexception.AbstractInvalidArgumentException;
import ch.nolix.coreapi.errorcontrol.exceptionargumentbox.ErrorPredicateDto;

public final class ArgumentDoesNotBelongToParentException
extends AbstractInvalidArgumentException {
    private static final String DEFAULT_PARENT_TYPE_NAME = Object.class.getSimpleName();

    private ArgumentDoesNotBelongToParentException(Object argument) {
        super(argument, new ErrorPredicateDto("does not belong to a parent"));
    }

    private ArgumentDoesNotBelongToParentException(Object argument, Class<?> parentType) {
        super(argument, new ErrorPredicateDto("does not belong to a " + ArgumentDoesNotBelongToParentException.getNameOfParentType(parentType)));
    }

    public static ArgumentDoesNotBelongToParentException forArgument(Object argument) {
        return new ArgumentDoesNotBelongToParentException(argument);
    }

    public static ArgumentDoesNotBelongToParentException forArgumentAndParentType(Object argument, Class<?> parentType) {
        return new ArgumentDoesNotBelongToParentException(argument, parentType);
    }

    private static String getNameOfParentType(Class<?> parentType) {
        if (parentType == null) {
            throw new IllegalArgumentException("The given parent type is null.");
        }
        String name = parentType.getSimpleName();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return DEFAULT_PARENT_TYPE_NAME;
    }
}

