/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.document.chainednode;

import ch.nolix.coreapi.document.chainednode.IChainedNode;

public final class ChainedNodeComparator {
    private ChainedNodeComparator() {
    }

    public static boolean areEqual(IChainedNode chainedNode1, IChainedNode chainedNode2) {
        if (chainedNode1 == null) {
            return chainedNode2 == null;
        }
        return chainedNode2 != null && ChainedNodeComparator.areEqualWhenNotNull(chainedNode1, chainedNode2);
    }

    private static boolean areEqualWhenNotNull(IChainedNode chainedNode1, IChainedNode chainedNode2) {
        return ChainedNodeComparator.canEqualBecauseOfHeaderWhenNotNull(chainedNode1, chainedNode2) && ChainedNodeComparator.canEqualBecauseOfChildNodesWhenNotNull(chainedNode1, chainedNode2);
    }

    private static boolean canEqualBecauseOfHeaderWhenNotNull(IChainedNode chainedNode1, IChainedNode chainedNode2) {
        if (!chainedNode1.hasHeader()) {
            return !chainedNode2.hasHeader();
        }
        return chainedNode2.hasHeader(chainedNode1.getHeader());
    }

    private static boolean canEqualBecauseOfChildNodesWhenNotNull(IChainedNode chainedNode1, IChainedNode chainedNode2) {
        return chainedNode1.getChildNodes().containsExactlyEqualingInSameOrder(chainedNode2.getChildNodes());
    }
}

