/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.matrix;

import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.matrix.Matrix;
import ch.nolix.core.container.matrix.MatrixRowIterator;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;

public final class MatrixRow<E>
extends AbstractExtendedContainer<E> {
    private final Matrix<E> parentMatrix;
    private final int rowIndex;

    MatrixRow(Matrix<E> parentMatrix, int rowIndex) {
        Validator.assertThat(parentMatrix).thatIsNamed("parent matrix").isNotNull();
        Validator.assertThat(rowIndex).thatIsNamed("row index").isPositive();
        this.parentMatrix = parentMatrix;
        this.rowIndex = rowIndex;
    }

    @Override
    public int getCount() {
        return this.parentMatrix.getColumnCount();
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public E getStoredAtOneBasedIndex(int columnIndex) {
        return this.parentMatrix.getStoredAtOneBasedRowIndexAndColumnIndex(this.getRowIndex(), columnIndex);
    }

    @Override
    public boolean isMaterialized() {
        return false;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return MatrixRowIterator.forMatrixRow(this);
    }

    public String toString() {
        return this.toStringWithSeparator(',');
    }
}

