/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.matrix;

import ch.nolix.core.container.matrix.MatrixColumn;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.NoSuchElementException;

final class MatrixColumnIterator<E>
implements CopyableIterator<E> {
    private final MatrixColumn<E> parentMatrixColumn;
    private int nextElementOneBasedRowIndex = 1;

    private MatrixColumnIterator(MatrixColumn<E> parentMatrixColumn) {
        Validator.assertThat(parentMatrixColumn).thatIsNamed("parent MatrixColumn").isNotNull();
        this.parentMatrixColumn = parentMatrixColumn;
    }

    private MatrixColumnIterator(MatrixColumn<E> parentMatrixColumn, int nextElementOneBasedRowIndex) {
        Validator.assertThat(parentMatrixColumn).thatIsNamed("parent MatrixColumn").isNotNull();
        Validator.assertThat(nextElementOneBasedRowIndex).thatIsNamed("next element 1-based row index").isPositive();
        this.parentMatrixColumn = parentMatrixColumn;
        this.nextElementOneBasedRowIndex = nextElementOneBasedRowIndex;
    }

    public static <T> MatrixColumnIterator<T> forMatrixColumn(MatrixColumn<T> matrixColumn) {
        return new MatrixColumnIterator<T>(matrixColumn);
    }

    @Override
    public CopyableIterator<E> getCopy() {
        return new MatrixColumnIterator<E>(this.parentMatrixColumn, this.nextElementOneBasedRowIndex);
    }

    @Override
    public boolean hasNext() {
        return this.nextElementOneBasedRowIndex <= this.parentMatrixColumn.getCount();
    }

    @Override
    public E next() {
        this.assertHasNext();
        return this.nextWhenHasNext();
    }

    private void assertHasNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "next element").toNoSuchElementException();
        }
    }

    private E nextWhenHasNext() {
        E element = this.parentMatrixColumn.getStoredAtOneBasedIndex(this.nextElementOneBasedRowIndex);
        ++this.nextElementOneBasedRowIndex;
        return element;
    }
}

