/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.linkedlist;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import java.util.function.Predicate;

public final class LinkedListNode<E> {
    private E memberElement;
    private LinkedListNode<E> nullableNextNode;

    private LinkedListNode(E element) {
        this.setElement(element);
    }

    public static <T> LinkedListNode<T> withElement(T element) {
        return new LinkedListNode<T>(element);
    }

    public boolean contains(Predicate<E> selector) {
        return selector.test(this.memberElement);
    }

    public boolean contains(Object element) {
        return this.memberElement == element;
    }

    public E getElement() {
        return this.memberElement;
    }

    public LinkedListNode<E> getNextNode() {
        if (this.nullableNextNode == null) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "next node");
        }
        return this.nullableNextNode;
    }

    public boolean hasNextNode() {
        return this.nullableNextNode != null;
    }

    public void removeNextNode() {
        this.nullableNextNode = null;
    }

    public void setElement(E element) {
        if (element == null) {
            throw ArgumentIsNullException.forArgumentName("element");
        }
        this.memberElement = element;
    }

    public void setNextNode(LinkedListNode<E> nextNode) {
        if (nextNode == null) {
            throw ArgumentIsNullException.forArgumentName("next node");
        }
        this.nullableNextNode = nextNode;
    }

    public void swapElementWithNextNode() {
        if (this.nullableNextNode == null) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "next node");
        }
        E element = this.nullableNextNode.getElement();
        this.nullableNextNode.setElement(this.memberElement);
        this.setElement(element);
    }
}

