/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.base;

import ch.nolix.core.commontypetool.iteratortool.IterableTool;
import ch.nolix.core.container.arraylist.MappingContainerView;
import ch.nolix.core.container.base.Marker;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotContainElementException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.errorcontrol.invalidargumentexception.EmptyArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.IArrayList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public abstract class AbstractContainer<E>
implements IContainer<E> {
    @Override
    public final boolean contains(Object object) {
        for (Object e : this) {
            if (e != object) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean containsAll(Iterable<?> objects) {
        Validator.assertThat(objects).thatIsNamed("objects").isNotNull();
        for (Object o : objects) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean containsAll(Object object, Object ... objects) {
        return this.contains(object) && this.containsAll(objects);
    }

    @Override
    public final boolean containsAll(Object[] objects) {
        Validator.assertThat(objects).thatIsNamed("objects").isNotNull();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (!this.contains(o)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public final boolean containsAny(Predicate<E> selector) {
        Validator.assertThat(selector).thatIsNamed("selector").isNotNull();
        for (Object e : this) {
            if (e == null || !selector.test(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean containsAny(Object object, Object ... objects) {
        return this.contains(object) || this.containsAnyOf(objects);
    }

    @Override
    public final boolean containsAnyOf(Iterable<?> objects) {
        Validator.assertThat(objects).thatIsNamed("objects").isNotNull();
        for (Object o : objects) {
            if (!this.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean containsAnyOf(Object[] objects) {
        Validator.assertThat(objects).thatIsNamed("objects").isNotNull();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (this.contains(o)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public final boolean containsAsManyAs(Iterable<?> iterable) {
        if (iterable instanceof IContainer) {
            IContainer container = (IContainer)iterable;
            return this.getCount() == container.getCount();
        }
        return this.getCount() == IterableTool.getCount(iterable);
    }

    @Override
    public final boolean containsEqualing(Object element) {
        for (Object e : this) {
            if (!e.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean containsExactlyEqualingInSameOrder(Iterable<?> iterable) {
        if (iterable == null) {
            return this.isEmpty();
        }
        return this.containsExactlyEqualingInSameOrderWhenGivenIterableIsNotNull(iterable);
    }

    @Override
    public final boolean containsExactlyInSameOrder(Iterable<?> iterable) {
        if (iterable == null) {
            return this.isEmpty();
        }
        return this.containsExactlyInSameOrderWhenGivenIterableIsNotNull(iterable);
    }

    @Override
    public final boolean containsLessThan(Iterable<?> iterable) {
        if (iterable instanceof IContainer) {
            IContainer container = (IContainer)iterable;
            return this.getCount() < container.getCount();
        }
        return this.getCount() < IterableTool.getCount(iterable);
    }

    @Override
    public final boolean containsMoreThan(Iterable<?> iterable) {
        if (iterable instanceof IContainer) {
            IContainer container = (IContainer)iterable;
            return this.getCount() > container.getCount();
        }
        return this.getCount() > IterableTool.getCount(iterable);
    }

    @Override
    public final boolean containsNone(Predicate<E> selector) {
        return !this.containsAny(selector);
    }

    @Override
    public final boolean containsNone(Object object, Object ... objects) {
        return !this.containsAny(object, objects);
    }

    @Override
    public final boolean containsNoneOf(Iterable<?> elements) {
        return !this.containsAnyOf(elements);
    }

    @Override
    public final boolean containsOnce(Object object) {
        boolean found = false;
        for (Object e : this) {
            if (e != object) continue;
            if (found) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Override
    public final boolean containsOne() {
        Iterator iterator = this.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        iterator.next();
        return !iterator.hasNext();
    }

    @Override
    public final boolean containsOne(Predicate<E> selector) {
        Validator.assertThat(selector).thatIsNamed("selector").isNotNull();
        boolean found = false;
        for (Object e : this) {
            if (e == null || !selector.test(e)) continue;
            if (found) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Override
    public final boolean containsOneEqualing(E object) {
        boolean found = false;
        for (Object e : this) {
            if (!Objects.equals(e, object)) continue;
            if (found) {
                return false;
            }
            found = true;
        }
        return found;
    }

    @Override
    public final boolean containsOnly(Predicate<E> selector) {
        Validator.assertThat(selector).thatIsNamed("selector").isNotNull();
        for (Object e : this) {
            if (e != null && selector.test(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final double getAverage(Function<E, Number> valueMapper) {
        this.assertIsNotEmpty();
        BigDecimal sumAsBigDecimal = this.getSum(valueMapper);
        BigDecimal elementCountAsBigDecimal = BigDecimal.valueOf(this.getCount());
        BigDecimal averageAsBigDecimal = sumAsBigDecimal.divide(elementCountAsBigDecimal, MathContext.DECIMAL32);
        return averageAsBigDecimal.doubleValue();
    }

    @Override
    public final double getAverageOrZero(Function<E, Number> mapper) {
        if (this.isEmpty()) {
            if (mapper == null) {
                throw ArgumentIsNullException.forArgumentName("mapper");
            }
            return 0.0;
        }
        return this.getAverage(mapper);
    }

    @Override
    public final int getCount(Predicate<E> selector) {
        Validator.assertThat(selector).thatIsNamed("selector").isNotNull();
        int count = 0;
        for (Object e : this) {
            if (e == null || !selector.test(e)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public final int getCountOf(Object element) {
        int count = 0;
        for (Object e : this) {
            if (e != element) continue;
            ++count;
        }
        return count;
    }

    @Override
    public final int getOneBasedIndexOfFirst(Predicate<E> selector) {
        Validator.assertThat(selector).thatIsNamed("selector").isNotNull();
        int localOneBasedIndex = 1;
        for (Object e : this) {
            if (e != null && selector.test(e)) {
                return localOneBasedIndex;
            }
            ++localOneBasedIndex;
        }
        throw ArgumentDoesNotContainElementException.forArgument(this);
    }

    @Override
    public final int getOneBasedIndexOfFirstEqualElement(Object object) {
        int localOneBasedIndex = 1;
        for (Object e : this) {
            if (Objects.equals(e, object)) {
                return localOneBasedIndex;
            }
            ++localOneBasedIndex;
        }
        throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "does not contain an element that equals '" + String.valueOf(object) + "'.");
    }

    @Override
    public final int getOneBasedIndexOfFirstOccurrenceOf(Object object) {
        int localOneBasedIndex = 1;
        for (Object e : this) {
            if (e == object) {
                return localOneBasedIndex;
            }
            ++localOneBasedIndex;
        }
        throw ArgumentDoesNotContainElementException.forArgumentAndElement(this, object);
    }

    @Override
    public final <C extends Comparable<C>> C getMax(Function<E, C> comparableMapper) {
        Validator.assertThat(comparableMapper).thatIsNamed("Comparable mapper").isNotNull();
        Comparable max = null;
        for (Object e : this) {
            if (e == null) continue;
            Comparable comparable = (Comparable)comparableMapper.apply(e);
            if (max != null && comparable.compareTo(max) <= 0) continue;
            max = comparable;
        }
        if (max == null) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "does not contain a non-null element");
        }
        return (C)max;
    }

    @Override
    public final double getMaxOrZero(Function<E, Number> numberMapper) {
        Validator.assertThat(numberMapper).thatIsNamed("Number mapper").isNotNull();
        Double max = null;
        for (Object e : this) {
            if (e == null) continue;
            double number = numberMapper.apply(e).doubleValue();
            if (max != null && !(number > max)) continue;
            max = number;
        }
        if (max == null) {
            return 0.0;
        }
        return max;
    }

    @Override
    public final double getMedian(Function<E, Number> numberMapper) {
        this.assertIsNotEmpty();
        IContainer<Number> numbers = this.toNumbers(numberMapper);
        IContainer<Number> orderedValues = numbers.toOrderedList(Number::doubleValue);
        int valueCount = numbers.getCount();
        if (valueCount % 2 == 0) {
            int preMedianIndex = valueCount / 2;
            int postMedianIndex = preMedianIndex + 1;
            double preMedian = ((Number)orderedValues.getStoredAtOneBasedIndex(preMedianIndex)).doubleValue();
            double postMedian = ((Number)orderedValues.getStoredAtOneBasedIndex(postMedianIndex)).doubleValue();
            return 0.5 * (preMedian + postMedian);
        }
        int medianIndex = valueCount / 2 + 1;
        return ((Number)orderedValues.getStoredAtOneBasedIndex(medianIndex)).doubleValue();
    }

    @Override
    public final double getMedianOrZero(Function<E, Number> norm) {
        if (this.isEmpty()) {
            return 0.0;
        }
        return this.getMedian(norm);
    }

    @Override
    public final <C extends Comparable<C>> C getMin(Function<E, C> comparableMapper) {
        Validator.assertThat(comparableMapper).thatIsNamed("Comparable mapper").isNotNull();
        Comparable min = null;
        for (Object e : this) {
            if (e == null) continue;
            Comparable comparable = (Comparable)comparableMapper.apply(e);
            if (min != null && comparable.compareTo(min) >= 0) continue;
            min = comparable;
        }
        if (min == null) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "does not contain a non-null element");
        }
        return (C)min;
    }

    @Override
    public final double getMinOrZero(Function<E, Number> numberMapper) {
        Validator.assertThat(numberMapper).thatIsNamed("Number mapper").isNotNull();
        Double min = null;
        for (Object e : this) {
            if (e == null) continue;
            double number = numberMapper.apply(e).doubleValue();
            if (min != null && !(number < min)) continue;
            min = number;
        }
        if (min == null) {
            return 0.0;
        }
        return min;
    }

    @Override
    public final Optional<E> getOptionalStoredFirst() {
        Iterator iterator = this.iterator();
        if (iterator.hasNext()) {
            return Optional.ofNullable(iterator.next());
        }
        return Optional.empty();
    }

    @Override
    public final Optional<E> getOptionalStoredFirst(Predicate<? super E> selector) {
        Validator.assertThat(selector).thatIsNamed("selector").isNotNull();
        for (Object e : this) {
            if (e == null || !selector.test(e)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    @Override
    public final double getStandardDeviation(Function<E, Number> norm) {
        double variance = this.getVariance(norm);
        return Math.sqrt(variance);
    }

    @Override
    public final <C extends Comparable<C>> E getStoredByMax(Function<E, C> comparableMapper) {
        Validator.assertThat(comparableMapper).thatIsNamed("Comparable mapper").isNotNull();
        E max = null;
        Comparable comparebleOfMax = null;
        for (Object e : this) {
            if (e == null) continue;
            Comparable comparable = (Comparable)comparableMapper.apply(e);
            if (max != null && comparable.compareTo(comparebleOfMax) <= 0) continue;
            max = e;
            comparebleOfMax = comparable;
        }
        if (max == null) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "does not contain a non-null element");
        }
        return max;
    }

    @Override
    public final <C extends Comparable<C>> E getStoredByMin(Function<E, C> comparableMapper) {
        Validator.assertThat(comparableMapper).thatIsNamed("Comparable mapper").isNotNull();
        E min = null;
        Comparable comparebleOfMin = null;
        for (Object e : this) {
            if (e == null) continue;
            Comparable comparable = (Comparable)comparableMapper.apply(e);
            if (min != null && comparable.compareTo(comparebleOfMin) >= 0) continue;
            min = e;
            comparebleOfMin = comparable;
        }
        if (min == null) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "does not contain a non-null element");
        }
        return min;
    }

    @Override
    public final E getStoredFirst() {
        Iterator iterator = this.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw EmptyArgumentException.forArgument(this);
    }

    @Override
    public final E getStoredFirst(Predicate<? super E> selector) {
        for (Object e : this) {
            if (e == null || !selector.test(e)) continue;
            return e;
        }
        throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "element the given selector selects");
    }

    @Override
    public final <T extends E> T getStoredFirstOfType(Class<T> type) {
        Validator.assertThat(type).thatIsNamed("type").isNotNull();
        return (T)this.getStoredFirst(e -> type.isAssignableFrom(e.getClass()));
    }

    @Override
    public final IContainer<? extends IContainer<E>> getStoredInGroups(Function<E, ?> norm) {
        Validator.assertThat(norm).thatIsNamed("norm").isNotNull();
        IArrayList groups = this.createEmptyMutableList(new Marker());
        for (Object e : this) {
            if (e == null) continue;
            Object groupKey = norm.apply(e);
            Optional<IArrayList> optionalGroup = groups.getOptionalStoredFirst(g -> g.containsAny() && norm.apply(g.getStoredFirst()).equals(groupKey));
            if (optionalGroup.isEmpty()) {
                IArrayList group = this.createEmptyMutableList(new Marker());
                group.addAtEnd(e);
                groups.addAtEnd(group);
                continue;
            }
            optionalGroup.get().addAtEnd(e);
        }
        return groups;
    }

    @Override
    public final E getStoredLast() {
        return this.getStoredAtOneBasedIndex(this.getCount());
    }

    @Override
    public final <T extends E> IContainer<T> getStoredOfType(Class<T> type) {
        Validator.assertThat(type).thatIsNamed("type").isNotNull();
        return this.getStoredSelected(e -> type.isAssignableFrom(e.getClass()));
    }

    @Override
    public final E getStoredOne() {
        switch (this.getCount()) {
            case 0: {
                throw EmptyArgumentException.forArgument(this);
            }
            case 1: {
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "contains several elements");
            }
        }
        return this.iterator().next();
    }

    @Override
    public final E getStoredOne(Predicate<? super E> selector) {
        Validator.assertThat("selector").isNotNull();
        E selectedElement = null;
        for (Object e : this) {
            if (e == null || !selector.test(e)) continue;
            if (selectedElement != null) {
                throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "contains several elements the given selector selects");
            }
            selectedElement = e;
        }
        if (selectedElement == null) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "does not contain an element the given selector selects");
        }
        return selectedElement;
    }

    @Override
    public final IContainer<E> getStoredOthers(Predicate<E> selector) {
        Validator.assertThat(selector).thatIsNamed("selector").isNotNull();
        IArrayList otherElements = this.createEmptyMutableList(new Marker());
        for (Object e : this) {
            if (e == null || selector.test(e)) continue;
            otherElements.addAtEnd(e);
        }
        return otherElements;
    }

    @Override
    public final IContainer<E> getStoredSelected(Predicate<? super E> selector) {
        Validator.assertThat(selector).thatIsNamed("selector").isNotNull();
        IArrayList selectedElements = this.createEmptyMutableList(new Marker());
        for (Object e : this) {
            if (e == null || !selector.test(e)) continue;
            selectedElements.addAtEnd(e);
        }
        return selectedElements;
    }

    @Override
    public final BigDecimal getSum(Function<E, Number> valueMapper) {
        Validator.assertThat(valueMapper).thatIsNamed("value mapper").isNotNull();
        BigDecimal sum = BigDecimal.ZERO;
        for (Object e : this) {
            if (e == null) continue;
            sum = sum.add(BigDecimal.valueOf(valueMapper.apply(e).doubleValue()));
        }
        return sum;
    }

    @Override
    public final BigInteger getSumOfInts(ToIntFunction<E> intMapper) {
        Validator.assertThat(intMapper).thatIsNamed("int mapper").isNotNull();
        BigInteger sum = BigInteger.ZERO;
        for (Object e : this) {
            if (e == null) continue;
            sum = sum.add(BigInteger.valueOf(intMapper.applyAsInt(e)));
        }
        return sum;
    }

    @Override
    public final double getVariance(Function<E, Number> numberMapper) {
        double average = this.getAverage(numberMapper);
        BigDecimal sumOfSquaredDifferencesToAverage = BigDecimal.ZERO;
        for (Object e : this) {
            double number = 0.0;
            if (e != null) {
                number = numberMapper.apply(e).doubleValue();
            }
            double differenceToAverage = number - average;
            double squaredDifferenceToAverage = Math.pow(differenceToAverage, 2.0);
            sumOfSquaredDifferencesToAverage = sumOfSquaredDifferencesToAverage.add(BigDecimal.valueOf(squaredDifferenceToAverage));
        }
        BigDecimal elementCount = BigDecimal.valueOf(this.getCount());
        return sumOfSquaredDifferencesToAverage.divide(elementCount, MathContext.DECIMAL32).doubleValue();
    }

    @Override
    public <T> IContainer<T> getViewOf(Function<E, T> mapper) {
        return MappingContainerView.forContainerAndMapper(this, mapper);
    }

    @Override
    public final IContainer<E> getViewFromOneBasedStartIndex(int oneBasedStartIndex) {
        return this.getViewFromOneBasedStartIndexToOneBasedEndIndex(oneBasedStartIndex, this.getCount());
    }

    @Override
    public final IContainer<E> getViewToOneBasedEndIndex(int oneBasedEndIndex) {
        return this.getViewFromOneBasedStartIndexToOneBasedEndIndex(1, oneBasedEndIndex);
    }

    @Override
    public final IContainer<E> getViewWithoutFirst() {
        return this.getViewWithoutFirst(1);
    }

    @Override
    public final IContainer<E> getViewWithoutFirst(int n) {
        Validator.assertThat(n).thatIsNamed("n").isNotNegative();
        int count = this.getCount();
        if (count > n) {
            return this.getViewFromOneBasedStartIndexToOneBasedEndIndex(n + 1, count);
        }
        return this.createEmptyMutableList(new Marker());
    }

    @Override
    public final IContainer<E> getViewWithoutLast() {
        return this.getViewWithoutLast(1);
    }

    @Override
    public final IContainer<E> getViewWithoutLast(int n) {
        Validator.assertThat(n).thatIsNamed("n").isNotNegative();
        int count = this.getCount();
        if (count > 0) {
            return this.getViewFromOneBasedStartIndexToOneBasedEndIndex(1, count - n);
        }
        return this.createEmptyMutableList(new Marker());
    }

    @Override
    public final boolean isEmpty() {
        for (Object e : this) {
            if (e == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public final <T> IContainer<T> to(Function<E, T> mapper) {
        Validator.assertThat(mapper).thatIsNamed("mapper").isNotNull();
        IArrayList list = this.createEmptyMutableList(new Marker());
        for (Object e : this) {
            if (e == null) {
                throw ArgumentIsNullException.forArgumentName("element");
            }
            T mappingElement = mapper.apply(e);
            list.addAtEnd(mappingElement);
        }
        return list;
    }

    @Override
    public final Object[] toArray() {
        Object[] array = new Object[this.getCount()];
        int index = 0;
        for (Object e : this) {
            array[index] = e;
            ++index;
        }
        return array;
    }

    @Override
    public final byte[] toByteArray(Function<E, Byte> byteMapper) {
        Validator.assertThat(byteMapper).thatIsNamed("byte mapper").isNotNull();
        byte[] array = new byte[this.getCount()];
        int index = 0;
        for (Object e : this) {
            array[index] = e == null ? (byte)0 : byteMapper.apply(e);
            ++index;
        }
        return array;
    }

    @Override
    public final char[] toCharArray(Function<E, Character> charMapper) {
        Validator.assertThat(charMapper).thatIsNamed("char mapper").isNotNull();
        char[] array = new char[this.getCount()];
        int index = 0;
        for (Object e : this) {
            array[index] = e == null ? 32 : charMapper.apply(e).charValue();
            ++index;
        }
        return array;
    }

    @Override
    public final String toConcatenatedString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object e : this) {
            stringBuilder.append(e);
        }
        return stringBuilder.toString();
    }

    @Override
    public final double[] toDoubleArray(ToDoubleFunction<E> doubleMapper) {
        Validator.assertThat(doubleMapper).thatIsNamed("double mapper").isNotNull();
        double[] array = new double[this.getCount()];
        int index = 0;
        for (Object e : this) {
            array[index] = e == null ? 0.0 : doubleMapper.applyAsDouble(e);
            ++index;
        }
        return array;
    }

    @Override
    public final int[] toIntArray(ToIntFunction<E> intMapper) {
        Validator.assertThat(intMapper).thatIsNamed("int mapper").isNotNull();
        int[] array = new int[this.getCount()];
        int index = 0;
        for (Object e : this) {
            array[index] = e == null ? 0 : intMapper.applyAsInt(e);
            ++index;
        }
        return array;
    }

    @Override
    public final long[] toLongArray(ToLongFunction<E> longMapper) {
        Validator.assertThat(longMapper).thatIsNamed("long mapper").isNotNull();
        long[] array = new long[this.getCount()];
        int index = 0;
        for (Object e : this) {
            array[index] = e == null ? 0L : longMapper.applyAsLong(e);
            ++index;
        }
        return array;
    }

    @Override
    public final <T> IContainer<T> toMultiples(Function<E, IContainer<T>> multipleMapper) {
        Validator.assertThat(multipleMapper).thatIsNamed("multiple mapper").isNotNull();
        IArrayList list = this.createEmptyMutableList(new Marker());
        for (Object e : this) {
            if (e == null) {
                throw ArgumentIsNullException.forArgumentName("element");
            }
            list.addAtEnd((Iterable)multipleMapper.apply(e));
        }
        return list;
    }

    @Override
    public <N extends Number> IContainer<N> toNumbers(Function<E, N> numberMapper) {
        Validator.assertThat(numberMapper).thatIsNamed("number mapper").isNotNull();
        IArrayList numbers = this.createEmptyMutableList(new Marker());
        Double zero = 0.0;
        for (Object e : this) {
            if (e == null) {
                numbers.addAtEnd(zero);
                continue;
            }
            numbers.addAtEnd((Number)numberMapper.apply(e));
        }
        return numbers;
    }

    @Override
    public final IContainer<E> toReversedList() {
        IArrayList<Object> reversedList = this.createEmptyMutableList(new Marker());
        Object[] array = new Object[this.getCount()];
        int index = this.getCount() - 1;
        for (Object e : this) {
            array[index] = e;
            --index;
        }
        reversedList.addAtEnd(array);
        return reversedList;
    }

    @Override
    public final String[] toStringArray() {
        String[] stringArray = new String[this.getCount()];
        int i = 0;
        for (Object e : this) {
            stringArray[i] = e.toString();
            ++i;
        }
        return stringArray;
    }

    @Override
    public final IContainer<String> toStrings() {
        IArrayList<String> list = this.createEmptyMutableList(new Marker());
        for (Object e : this) {
            list.addAtEnd(Objects.toString(e));
        }
        return list;
    }

    @Override
    public final String toStringWithSeparator(char separator) {
        return this.toStringWithSeparator(String.valueOf(separator));
    }

    @Override
    public final String toStringWithSeparator(String separator) {
        return switch (this.getCount()) {
            case 0 -> "";
            case 1 -> this.getStoredFirst().toString();
            default -> this.toStringWhenContainsSeveralElements(separator);
        };
    }

    @Override
    public final <T> IContainer<T> toWithOneBasedIndex(BiFunction<Integer, E, T> mapper) {
        Validator.assertThat(mapper).thatIsNamed("mapper").isNotNull();
        IArrayList list = this.createEmptyMutableList(new Marker());
        int index = 1;
        for (Object e : this) {
            if (e == null) {
                throw ArgumentIsNullException.forArgumentName("element");
            }
            T mappingElement = mapper.apply(index, e);
            list.addAtEnd(mappingElement);
            ++index;
        }
        return list;
    }

    protected abstract <T> IArrayList<T> createEmptyMutableList(Marker<T> var1);

    private void assertIsNotEmpty() {
        if (this.isEmpty()) {
            throw EmptyArgumentException.forArgument(this);
        }
    }

    private boolean containsExactlyEqualingInSameOrderWhenGivenIterableIsNotNull(Iterable<?> iterable) {
        Iterator<?> iterator = iterable.iterator();
        for (Object e : this) {
            if (iterator.hasNext()) {
                if (Objects.equals(e, iterator.next())) continue;
                return false;
            }
            return false;
        }
        return !iterator.hasNext();
    }

    private boolean containsExactlyInSameOrderWhenGivenIterableIsNotNull(Iterable<?> iterable) {
        Iterator<?> iterator = iterable.iterator();
        for (Object e : this) {
            if (iterator.hasNext() && e == iterator.next()) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    private String toStringWhenContainsSeveralElements(String separator) {
        Validator.assertThat(separator).thatIsNamed("separator").isNotNull();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getStoredFirst());
        for (Object e : this.getViewWithoutFirst()) {
            stringBuilder.append(separator).append(e);
        }
        return stringBuilder.toString();
    }
}

