/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.arraylist;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.function.Function;

public final class MappingContainerViewIterator<E, T>
implements CopyableIterator<T> {
    private final CopyableIterator<E> iterator;
    private final Function<E, T> mapper;

    private MappingContainerViewIterator(CopyableIterator<E> iterator, Function<E, T> mapper) {
        Validator.assertThat(iterator).thatIsNamed("iterator").isNotNull();
        Validator.assertThat(mapper).thatIsNamed("mapper").isNotNull();
        this.iterator = iterator;
        this.mapper = mapper;
    }

    public static <T, T2> MappingContainerViewIterator<T, T2> forIteratorAndMapper(CopyableIterator<T> iterator, Function<T, T2> mapper) {
        return new MappingContainerViewIterator<T, T2>(iterator, mapper);
    }

    @Override
    public CopyableIterator<T> getCopy() {
        return MappingContainerViewIterator.forIteratorAndMapper((CopyableIterator)this.iterator.getCopy(), this.mapper);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.mapper.apply(this.iterator.next());
    }
}

